"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchFields = fetchFields;
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _index_patterns_utils = require("../../../common/index_patterns_utils");
var _fields_utils = require("../../../common/fields_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function fetchFields(indexes = [], signal) {
  const patterns = Array.isArray(indexes) ? indexes : [indexes];
  const coreStart = (0, _services.getCoreStart)();
  const defaultIndex = coreStart.uiSettings.get('defaultIndex');
  try {
    const indexFields = await Promise.all(patterns.map(async pattern => {
      try {
        if (typeof pattern !== 'string' && pattern !== null && pattern !== void 0 && pattern.id) {
          return (0, _fields_utils.toSanitizedFieldType)((await (0, _services.getDataViewsStart)().get(pattern.id)).getNonScriptedFields());
        } else {
          return coreStart.http.get(_constants.ROUTES.FIELDS, {
            query: {
              index: `${pattern !== null && pattern !== void 0 ? pattern : ''}`
            },
            signal
          });
        }
      } catch (e) {
        return [];
      }
    }));
    const fields = patterns.reduce((cumulatedFields, currentPattern, index) => {
      const key = (0, _index_patterns_utils.getIndexPatternKey)(currentPattern);
      return {
        ...cumulatedFields,
        [key]: indexFields[index],
        ...(key === defaultIndex ? {
          '': indexFields[index]
        } : {})
      };
    }, {});
    return fields;
  } catch (error) {
    if (error.name !== 'AbortError') {
      (0, _services.getCoreStart)().notifications.toasts.addDanger({
        title: _i18n.i18n.translate('visTypeTimeseries.fetchFields.loadIndexPatternFieldsErrorMessage', {
          defaultMessage: 'Unable to load index_pattern fields'
        }),
        text: error.message
      });
    }
  }
  return {};
}