"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _vis_with_splits = require("../../vis_with_splits");
var _get_metrics_field = require("../../lib/get_metrics_field");
var _tick_formatter = require("../../lib/tick_formatter");
var _create_field_formatter = require("../../lib/create_field_formatter");
var _lodash = require("lodash");
var _metric = require("../../../visualizations/views/metric");
var _enums = require("../../../../../common/enums");
var _last_value_utils = require("../../../../../common/last_value_utils");
var _set_is_reversed = require("../../../lib/set_is_reversed");
var _operators_utils = require("../../../../../common/operators_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getColors(props) {
  const {
    model,
    visData
  } = props;
  const series = (0, _lodash.get)(visData, `${model.id}.series`, []).filter(s => !(0, _lodash.isUndefined)(s));
  let color;
  let background;
  if (model.background_color_rules) {
    model.background_color_rules.forEach(rule => {
      if (rule.operator) {
        var _series$;
        const value = (0, _last_value_utils.getLastValue)((_series$ = series[0]) === null || _series$ === void 0 ? void 0 : _series$.data);
        if ((0, _operators_utils.shouldOperate)(rule, value) && (0, _operators_utils.getOperator)(rule.operator)(value, rule.value)) {
          background = rule.background_color;
          color = rule.color;
        }
      }
    });
  }
  return {
    color,
    background
  };
}
function MetricVisualization(props) {
  const {
    backgroundColor,
    model,
    visData,
    fieldFormatMap,
    getConfig
  } = props;
  const colors = getColors(props);
  const series = (0, _lodash.get)(visData, `${model.id}.series`, []).filter(row => row).map((row, i) => {
    const seriesDef = model.series.find(s => (0, _lodash.includes)(row.id, s.id));
    const newProps = {};
    if (seriesDef) {
      newProps.formatter = seriesDef.formatter === _enums.DATA_FORMATTERS.DEFAULT ? (0, _create_field_formatter.createFieldFormatter)((0, _get_metrics_field.getMetricsField)(seriesDef.metrics), fieldFormatMap, 'html', colors.color) : (0, _tick_formatter.createTickFormatter)(seriesDef.formatter, seriesDef.value_template, getConfig);
    }
    if (i === 0 && colors.color) newProps.color = colors.color;
    return (0, _lodash.assign)({}, (0, _lodash.pick)(row, ['label', 'data']), newProps);
  });
  const panelBackgroundColor = colors.background || backgroundColor;
  const style = {
    backgroundColor: panelBackgroundColor
  };
  const params = {
    metric: series[0],
    additionalLabel: props.additionalLabel,
    reversed: (0, _set_is_reversed.isBackgroundInverted)(panelBackgroundColor)
  };
  if (series[1]) {
    params.secondary = series[1];
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbVis",
    style: style
  }, /*#__PURE__*/_react.default.createElement(_metric.Metric, (0, _extends2.default)({}, params, {
    initialRender: props.initialRender
  })));
}
MetricVisualization.propTypes = {
  backgroundColor: _propTypes.default.string,
  className: _propTypes.default.string,
  additionalLabel: _propTypes.default.string,
  model: _propTypes.default.object,
  onBrush: _propTypes.default.func,
  onFilterClick: _propTypes.default.func,
  onChange: _propTypes.default.func,
  visData: _propTypes.default.object,
  getConfig: _propTypes.default.func
};
const metric = (0, _vis_with_splits.visWithSplits)(MetricVisualization);

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = metric;
module.exports = exports.default;