"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelConfig = PanelConfig;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _form_validation_context = require("../../contexts/form_validation_context");
var _vis_data_context = require("../../contexts/vis_data_context");
var _panel_model_context = require("../../contexts/panel_model_context");
var _timeseries = require("./timeseries");
var _metric = require("./metric");
var _top_n = require("./top_n");
var _table = require("./table");
var _gauge = require("./gauge");
var _markdown = require("./markdown");
require("./_panel_config.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const panelConfigTypes = {
  timeseries: _timeseries.TimeseriesPanelConfig,
  table: _table.TablePanelConfig,
  metric: _metric.MetricPanelConfig,
  top_n: _top_n.TopNPanelConfig,
  gauge: _gauge.GaugePanelConfig,
  markdown: _markdown.MarkdownPanelConfig
};
const checkModelValidity = validationResults => Object.values(validationResults).every(isValid => isValid);
function PanelConfig(props) {
  const {
    model,
    onChange
  } = props;
  const Component = panelConfigTypes[model.type];
  const formValidationResults = (0, _react.useRef)({});
  const [visData, setVisData] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    const visDataSubscription = props.visData$.subscribe((data = {}) => setVisData(data));
    return () => visDataSubscription.unsubscribe();
  }, [model.id, props.visData$]);
  const updateControlValidity = (0, _react.useCallback)((controlKey, isControlValid) => {
    formValidationResults.current[controlKey] = isControlValid;
    onChange({
      isModelInvalid: !checkModelValidity(formValidationResults.current)
    });
  }, [onChange]);
  if (Component) {
    return /*#__PURE__*/_react.default.createElement(_form_validation_context.FormValidationContext.Provider, {
      value: updateControlValidity
    }, /*#__PURE__*/_react.default.createElement(_panel_model_context.PanelModelContext.Provider, {
      value: model
    }, /*#__PURE__*/_react.default.createElement(_vis_data_context.VisDataContext.Provider, {
      value: visData
    }, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": `tvbPanelConfig__${model.type}`
    }, /*#__PURE__*/_react.default.createElement(Component, props)))));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.missingPanelConfigDescription",
    defaultMessage: "Missing panel config for \u201C{modelType}\u201D",
    values: {
      modelType: model.type
    }
  }));
}