"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newSeriesFn = void 0;
var _uuid = require("uuid");
var _lodash = _interopRequireDefault(require("lodash"));
var _new_metric_agg_fn = require("./new_metric_agg_fn");
var _constants = require("../../visualizations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const newSeriesFn = (obj = {}) => {
  return _lodash.default.assign({
    id: (0, _uuid.v4)(),
    color: '#68BC00',
    split_mode: 'everything',
    palette: {
      type: 'palette',
      name: 'default'
    },
    metrics: [(0, _new_metric_agg_fn.newMetricAggFn)()],
    separate_axis: 0,
    axis_position: 'right',
    formatter: 'default',
    chart_type: 'line',
    line_width: 1,
    point_size: 1,
    fill: 0.5,
    stacked: _constants.STACKED_OPTIONS.NONE,
    override_index_pattern: 0,
    series_drop_last_bucket: 0
  }, obj);
};
exports.newSeriesFn = newSeriesFn;