"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwitchModePopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../../services");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const allowStringIndicesMessage = _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.switchModePopover.allowStringIndices', {
  defaultMessage: 'Allow string indices in TSVB'
});
const SwitchModePopover = ({
  onModeChange,
  useKibanaIndices
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(isOpen => !isOpen), []);
  const switchMode = (0, _react.useCallback)(() => {
    onModeChange(!useKibanaIndices);
  }, [onModeChange, useKibanaIndices]);
  const {
    application
  } = (0, _services.getCoreStart)();
  const canEditAdvancedSettings = application.capabilities.advancedSettings.save;
  const handleAllowStringIndicesLinkClick = (0, _react.useCallback)(() => application.navigateToApp('management', {
    path: `/kibana/settings?query=${_constants.UI_SETTINGS.ALLOW_STRING_INDICES}`
  }), [application]);
  const stringIndicesAllowed = (0, _services.getUISettings)().get(_constants.UI_SETTINGS.ALLOW_STRING_INDICES);
  const isSwitchDisabled = useKibanaIndices && !stringIndicesAllowed;
  let allowStringIndicesLabel;
  if (!stringIndicesAllowed) {
    allowStringIndicesLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.indexPatternSelect.switchModePopover.enableAllowStringIndices",
      defaultMessage: "To query Elasticsearch indices, you must enable the {allowStringIndices} setting.",
      values: {
        allowStringIndices: canEditAdvancedSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          color: "accent",
          onClick: handleAllowStringIndicesLinkClick
        }, allowStringIndicesMessage) : /*#__PURE__*/_react.default.createElement("strong", null, allowStringIndicesMessage)
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: 'gear',
      "aria-label": _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.switchModePopover.areaLabel', {
        defaultMessage: 'Configure data view selection mode'
      }),
      onClick: onButtonClick,
      "data-test-subj": "switchIndexPatternSelectionModePopoverButton"
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    style: {
      height: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '360px'
    },
    "data-test-subj": "switchIndexPatternSelectionModePopoverContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.switchModePopover.title', {
    defaultMessage: 'Data view mode'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.indexPatternSelect.switchModePopover.text",
    defaultMessage: "A data view groups and retrieves data from Elasticsearch. Disable this mode to directly query Elasticsearch indices instead. {allowStringIndicesLabel}",
    values: {
      allowStringIndicesLabel
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: useKibanaIndices,
    label: _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.switchModePopover.useKibanaIndices', {
      defaultMessage: 'Use Kibana data views'
    }),
    onChange: switchMode,
    disabled: isSwitchDisabled,
    "data-test-subj": "switchIndexPatternSelectionMode"
  })));
};
exports.SwitchModePopover = SwitchModePopover;