"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateSiblings = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getAncestors(siblings, item) {
  const ancestors = item.id && [item.id] || [];
  siblings.forEach(sib => {
    if (_lodash.default.includes(ancestors, sib.field)) {
      ancestors.push(sib.id);
    }
  });
  return ancestors;
}
const calculateSiblings = (siblings, model) => {
  const ancestors = getAncestors(siblings, model);
  return siblings.filter(row => !_lodash.default.includes(ancestors, row.id));
};
exports.calculateSiblings = calculateSiblings;