"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.colorRulesOperatorsList = exports.ColorRules = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _add_delete_buttons = require("./add_delete_buttons");
var _collection_actions = require("./lib/collection_actions");
var _color_picker = require("./color_picker");
var _operators_utils = require("../../../common/operators_utils");
var _common = require("../styles/common.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultSecondaryName = _i18n.i18n.translate('visTypeTimeseries.colorRules.defaultSecondaryNameLabel', {
  defaultMessage: 'text'
});
const defaultPrimaryName = _i18n.i18n.translate('visTypeTimeseries.colorRules.defaultPrimaryNameLabel', {
  defaultMessage: 'background'
});
const colorRulesOperatorsList = [{
  label: _i18n.i18n.translate('visTypeTimeseries.colorRules.greaterThanLabel', {
    defaultMessage: '> greater than'
  }),
  method: _operators_utils.Operator.Gt
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.colorRules.greaterThanOrEqualLabel', {
    defaultMessage: '>= greater than or equal'
  }),
  method: _operators_utils.Operator.Gte
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.colorRules.lessThanLabel', {
    defaultMessage: '< less than'
  }),
  method: _operators_utils.Operator.Lt
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.colorRules.lessThanOrEqualLabel', {
    defaultMessage: '<= less than or equal'
  }),
  method: _operators_utils.Operator.Lte
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.colorRules.emptyLabel', {
    defaultMessage: 'empty'
  }),
  method: _operators_utils.Operator.Empty,
  hideValueSelector: true
}];
exports.colorRulesOperatorsList = colorRulesOperatorsList;
const operatorOptions = colorRulesOperatorsList.map(operator => ({
  label: operator.label,
  value: operator.method
}));
class ColorRulesUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleOperatorChange", item => {
      return options => {
        var _selectedOperator$val, _options$2;
        const selectedOperator = colorRulesOperatorsList.find(operator => {
          var _options$;
          return ((_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.value) === operator.method;
        });
        const value = (_selectedOperator$val = selectedOperator === null || selectedOperator === void 0 ? void 0 : selectedOperator.value) !== null && _selectedOperator$val !== void 0 ? _selectedOperator$val : null;
        _collection_actions.collectionActions.handleChange(this.props, {
          ...item,
          operator: (_options$2 = options[0]) === null || _options$2 === void 0 ? void 0 : _options$2.value,
          value
        });
      };
    });
    this.renderRow = this.renderRow.bind(this);
  }
  handleValueChange(item) {
    return e => {
      let value = Number(e.target.value);
      if (isNaN(value)) value = undefined;
      _collection_actions.collectionActions.handleChange(this.props, {
        ...item,
        value
      });
    };
  }
  renderRow(row, i, items) {
    var _selectedOperator$hid, _this$props$primaryNa, _this$props$primaryVa, _this$props$primaryVa2, _model$value;
    const defaults = {
      value: 0
    };
    const model = {
      ...defaults,
      ...row
    };
    const handleAdd = () => _collection_actions.collectionActions.handleAdd(this.props);
    const handleDelete = () => _collection_actions.collectionActions.handleDelete(this.props, model);
    const handleColorChange = part => {
      _collection_actions.collectionActions.handleChange(this.props, {
        ...model,
        ...part
      });
    };
    const htmlId = (0, _eui.htmlIdGenerator)(model.id);
    const selectedOperatorOption = operatorOptions.find(option => model.operator === option.value);
    const selectedOperator = colorRulesOperatorsList.find(operator => model.operator === operator.method);
    const hideValueSelectorField = (_selectedOperator$hid = selectedOperator === null || selectedOperator === void 0 ? void 0 : selectedOperator.hideValueSelector) !== null && _selectedOperator$hid !== void 0 ? _selectedOperator$hid : false;
    const labelStyle = {
      marginBottom: 0
    };
    let secondary;
    if (!this.props.hideSecondary) {
      var _this$props$secondary, _this$props$secondary2;
      const secondaryVarName = (_this$props$secondary = this.props.secondaryVarName) !== null && _this$props$secondary !== void 0 ? _this$props$secondary : 'color';
      secondary = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        style: labelStyle
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.colorRules.setSecondaryColorLabel",
        defaultMessage: "and {secondaryName} to",
        values: {
          secondaryName: (_this$props$secondary2 = this.props.secondaryName) !== null && _this$props$secondary2 !== void 0 ? _this$props$secondary2 : defaultSecondaryName
        },
        description: "Part of a larger string: Set {primaryName} to {color} and {secondaryName} to {color} if metric is {greaterOrLessThan} {value}."
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
        onChange: handleColorChange,
        name: secondaryVarName,
        value: model[secondaryVarName]
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      responsive: false,
      gutterSize: "s",
      key: model.id,
      alignItems: "center",
      css: (0, _common.tsvbEditorRowStyles)(this.props.theme.euiTheme)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      style: labelStyle
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.colorRules.setPrimaryColorLabel",
      defaultMessage: "Set {primaryName} to",
      values: {
        primaryName: (_this$props$primaryNa = this.props.primaryName) !== null && _this$props$primaryNa !== void 0 ? _this$props$primaryNa : defaultPrimaryName
      },
      description: "Part of a larger string: Set {primaryName} to {color} and {secondaryName} to {color} if metric is {greaterOrLessThan} {value}."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
      onChange: handleColorChange,
      name: (_this$props$primaryVa = this.props.primaryVarName) !== null && _this$props$primaryVa !== void 0 ? _this$props$primaryVa : 'background_color',
      value: model[(_this$props$primaryVa2 = this.props.primaryVarName) !== null && _this$props$primaryVa2 !== void 0 ? _this$props$primaryVa2 : 'background_color']
    })), secondary, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      style: labelStyle,
      htmlFor: htmlId('ifMetricIs')
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.colorRules.ifMetricIsLabel",
      defaultMessage: "if metric is",
      description: "Part of a larger string: Set {primaryName} to {color} and {secondaryName} to {color} if metric is {greaterOrLessThan} {value}."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      id: htmlId('ifMetricIs'),
      options: operatorOptions,
      selectedOptions: selectedOperatorOption ? [selectedOperatorOption] : [],
      onChange: this.handleOperatorChange(model),
      singleSelection: {
        asPlainText: true
      },
      "data-test-subj": "colorRuleOperator",
      fullWidth: true
    })), !hideValueSelectorField && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "aria-label": _i18n.i18n.translate('visTypeTimeseries.colorRules.valueAriaLabel', {
        defaultMessage: 'Value'
      }),
      value: (_model$value = model.value) !== null && _model$value !== void 0 ? _model$value : '',
      onChange: this.handleValueChange(model),
      "data-test-subj": "colorRuleValue",
      fullWidth: true
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
      onAdd: handleAdd,
      onDelete: handleDelete,
      disableDelete: items.length < 2,
      responsive: false
    })));
  }
  render() {
    const {
      model,
      name
    } = this.props;
    return !model[name] ? /*#__PURE__*/_react.default.createElement("div", null) : /*#__PURE__*/_react.default.createElement("div", null, model[name].map(this.renderRow));
  }
}
const ColorRules = (0, _eui.withEuiTheme)(ColorRulesUI);
exports.ColorRules = ColorRules;