"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPicker = ColorPicker;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable jsx-a11y/click-events-have-key-events */
// The color picker is not yet accessible.

const COMMAS_NUMS_ONLY_RE = /[^0-9,]/g;
function ColorPicker({
  name,
  value,
  disableTrash = false,
  onChange
}) {
  const initialColorValue = value !== null && value !== void 0 && value.includes('rgba') ? value.replace(COMMAS_NUMS_ONLY_RE, '') : value;
  const [color, setColor] = (0, _react.useState)(initialColorValue || '');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleColorChange = (text, {
    rgba,
    hex
  }) => {
    setColor(text);
    onChange({
      [name]: hex ? `rgba(${rgba.join(',')})` : ''
    });
  };
  const handleClear = () => {
    setColor('');
    onChange({
      [name]: null
    });
  };
  const label = value ? _i18n.i18n.translate('visTypeTimeseries.colorPicker.notAccessibleWithValueAriaLabel', {
    defaultMessage: 'Color picker ({value}), not accessible',
    values: {
      value
    }
  }) : _i18n.i18n.translate('visTypeTimeseries.colorPicker.notAccessibleAriaLabel', {
    defaultMessage: 'Color picker, not accessible'
  });
  const tsvbColorPickerStyles = (0, _react2.css)`
    display: flex;
    align-items: center;
    position: relative;
  `;
  const tsvbColorPickerClearStyles = (0, _react2.css)`
    margin-left: ${euiTheme.size.xs};
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: tsvbColorPickerStyles,
    "data-test-subj": "tvbColorPicker"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    onChange: handleColorChange,
    color: color,
    secondaryInputDisplay: "top",
    showAlpha: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiColorPickerSwatch, {
      color: color,
      "aria-label": label
    })
  }), !disableTrash && /*#__PURE__*/_react.default.createElement("div", {
    css: tsvbColorPickerClearStyles,
    onClick: handleClear,
    "data-test-subj": "tvbColorPickerClear"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "s",
    type: "cross",
    color: "danger",
    content: _i18n.i18n.translate('visTypeTimeseries.colorPicker.clearIconLabel', {
      defaultMessage: 'Clear'
    })
  })));
}