"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelionVisRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _analytics = require("@kbn/analytics");
var _plugin_services = require("./helpers/plugin_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const LazyTimelionVisComponent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./async_services'))).then(({
  TimelionVisComponent
}) => ({
  default: TimelionVisComponent
})));

/** @internal **/
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};
const getTimelionVisRenderer = deps => ({
  name: 'timelion_vis',
  displayName: 'Timelion visualization',
  reuseDomNode: true,
  render: (domNode, {
    visData,
    visParams,
    syncTooltips,
    syncCursor
  }, handlers) => {
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const seriesList = visData === null || visData === void 0 ? void 0 : visData.sheet[0];
    const showNoResult = !seriesList || !seriesList.list.length;
    const onBrushEvent = rangeFilterParams => {
      handlers.event({
        name: 'applyFilter',
        data: {
          timeFieldName: '*',
          filters: [{
            query: {
              range: {
                '*': rangeFilterParams
              }
            }
          }]
        }
      });
    };
    const renderComplete = () => {
      const usageCollection = (0, _plugin_services.getUsageCollection)();
      const containerType = extractContainerType(handlers.getExecutionContext());
      if (usageCollection && containerType) {
        usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, `render_agg_based_timelion`);
      }
      handlers.done();
    };
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.VisualizationContainer, {
      renderComplete: renderComplete,
      handlers: handlers,
      showNoResult: showNoResult
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: deps.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...deps
      }
    }, seriesList && /*#__PURE__*/_react.default.createElement(LazyTimelionVisComponent, {
      interval: visParams.interval,
      ariaLabel: visParams.ariaLabel,
      seriesList: seriesList,
      renderComplete: renderComplete,
      onBrushEvent: onBrushEvent,
      syncTooltips: syncTooltips,
      syncCursor: syncCursor
    })))), domNode);
  }
});
exports.getTimelionVisRenderer = getTimelionVisRenderer;