"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarSeriesComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getBarSeriesStyle = ({
  color,
  bars
}) => {
  var _bars$fill, _bars$lineWidth;
  let opacity = (_bars$fill = bars.fill) !== null && _bars$fill !== void 0 ? _bars$fill : 1;
  if (opacity < 0) {
    opacity = 0;
  } else if (opacity > 1) {
    opacity = 1;
  }
  return {
    rectBorder: {
      visible: false
    },
    rect: {
      fill: color,
      opacity,
      widthPixel: Math.max(1, (_bars$lineWidth = bars.lineWidth) !== null && _bars$lineWidth !== void 0 ? _bars$lineWidth : 1)
    }
  };
};
const BarSeriesComponent = ({
  index,
  groupId,
  visData
}) => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
  id: index + visData.label,
  groupId: groupId,
  name: visData.label,
  xScaleType: _charts.ScaleType.Time,
  yScaleType: _charts.ScaleType.Linear,
  xAccessor: 0,
  yAccessors: [1],
  data: visData._hide ? [] : visData.data,
  enableHistogramMode: false,
  color: visData.color,
  stackAccessors: visData.stack ? [0] : undefined,
  barSeriesStyle: getBarSeriesStyle(visData)
});
exports.BarSeriesComponent = BarSeriesComponent;