"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTagCloudVisTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _get_tag_cloud_options = require("./components/get_tag_cloud_options");
var _to_ast = require("./to_ast");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const getTagCloudVisTypeDefinition = ({
  palettes
}) => {
  return {
    name: 'tagcloud',
    title: _i18n.i18n.translate('visTypeTagCloud.vis.tagCloudTitle', {
      defaultMessage: 'Tag cloud'
    }),
    icon: 'visTagCloud',
    getSupportedTriggers: () => {
      return [_public2.VIS_EVENT_TO_TRIGGER.filter];
    },
    description: _i18n.i18n.translate('visTypeTagCloud.vis.tagCloudDescription', {
      defaultMessage: 'Display word frequency with font size.'
    }),
    visConfig: {
      defaults: {
        scale: 'linear',
        orientation: 'single',
        minFontSize: 18,
        maxFontSize: 72,
        showLabel: true,
        palette: {
          name: 'default',
          type: 'palette'
        }
      }
    },
    fetchDatatable: true,
    toExpressionAst: _to_ast.toExpressionAst,
    editorConfig: {
      enableDataViewChange: true,
      optionsTemplate: (0, _get_tag_cloud_options.getTagCloudOptions)({
        palettes
      }),
      schemas: [{
        group: _public.AggGroupNames.Metrics,
        name: 'metric',
        title: _i18n.i18n.translate('visTypeTagCloud.vis.schemas.metricTitle', {
          defaultMessage: 'Tag size'
        }),
        min: 1,
        max: 1,
        aggFilter: ['!std_dev', '!percentiles', '!percentile_ranks', '!derivative', '!geo_bounds', '!geo_centroid', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
        defaults: [{
          schema: 'metric',
          type: 'count'
        }]
      }, {
        group: _public.AggGroupNames.Buckets,
        name: 'segment',
        title: _i18n.i18n.translate('visTypeTagCloud.vis.schemas.segmentTitle', {
          defaultMessage: 'Tags'
        }),
        min: 1,
        max: 1,
        aggFilter: ['terms', 'significant_terms']
      }]
    },
    requiresSearch: true,
    navigateToLens: async (vis, timefilter) => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
      return vis ? convertToLens(vis, timefilter) : null;
    },
    getExpressionVariables: async (vis, timeFilter) => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
      return {
        canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertToLens(vis, timeFilter) : null)
      };
    }
  };
};
exports.getTagCloudVisTypeDefinition = getTagCloudVisTypeDefinition;