"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _public = require("@kbn/expressions-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const prepareDimension = params => {
  const visdimension = (0, _public.buildExpressionFunction)('visdimension', {
    accessor: params.accessor
  });
  if (params.format) {
    visdimension.addArgument('format', params.format.id);
    visdimension.addArgument('formatParams', JSON.stringify(params.format.params));
  }
  return (0, _public.buildExpression)([visdimension]);
};
const getMetrics = (schemas, visParams) => {
  const metrics = [...schemas.metric];
  if (schemas.bucket && visParams.showPartialRows && !visParams.showMetricsAtAllLevels) {
    // Handle case where user wants to see partial rows but not metrics at all levels.
    // This requires calculating how many metrics will come back in the tabified response,
    // and removing all metrics from the dimensions except the last set.
    const metricsPerBucket = metrics.length / schemas.bucket.length;
    metrics.splice(0, metricsPerBucket * schemas.bucket.length - metricsPerBucket);
  }
  return metrics;
};
const toExpressionAst = (vis, params) => {
  var _schemas$bucket;
  const schemas = (0, _public2.getVisSchemas)(vis, params);
  const metrics = getMetrics(schemas, vis.params);
  const args = {
    // explicitly pass each param to prevent extra values trapping
    perPage: vis.params.perPage,
    percentageCol: vis.params.percentageCol,
    row: vis.params.row,
    showPartialRows: vis.params.showPartialRows,
    showMetricsAtAllLevels: vis.params.showMetricsAtAllLevels,
    showToolbar: vis.params.showToolbar,
    showTotal: vis.params.showTotal,
    autoFitRowToContent: vis.params.autoFitRowToContent,
    totalFunc: vis.params.totalFunc,
    title: vis.title,
    metrics: metrics.map(prepareDimension),
    buckets: (_schemas$bucket = schemas.bucket) === null || _schemas$bucket === void 0 ? void 0 : _schemas$bucket.map(prepareDimension)
  };
  const table = (0, _public.buildExpressionFunction)('kibana_table', args);
  if (schemas.split_column) {
    table.addArgument('splitColumn', prepareDimension(schemas.split_column[0]));
  }
  if (schemas.split_row) {
    table.addArgument('splitRow', prepareDimension(schemas.split_row[0]));
  }
  const ast = (0, _public.buildExpression)([table]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;