"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPieVisTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _common = require("@kbn/expression-partition-vis-plugin/common");
var _common2 = require("../../common");
var _to_ast = require("../to_ast");
var _components = require("../editor/components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const getPieVisTypeDefinition = ({
  showElasticChartsOptions = false,
  palettes
}) => ({
  name: 'pie',
  title: _i18n.i18n.translate('visTypePie.pie.pieTitle', {
    defaultMessage: 'Pie'
  }),
  icon: 'visPie',
  description: _i18n.i18n.translate('visTypePie.pie.pieDescription', {
    defaultMessage: 'Compare data in proportion to a whole.'
  }),
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  getSupportedTriggers: () => [_public2.VIS_EVENT_TO_TRIGGER.filter],
  visConfig: {
    defaults: {
      type: 'pie',
      addTooltip: true,
      legendDisplay: !showElasticChartsOptions ? _common.LegendDisplay.SHOW : _common.LegendDisplay.HIDE,
      legendPosition: _charts.Position.Right,
      nestedLegend: false,
      truncateLegend: true,
      maxLegendLines: 1,
      distinctColors: false,
      isDonut: true,
      emptySizeRatio: _common.EmptySizeRatios.SMALL,
      palette: {
        type: 'palette',
        name: 'default'
      },
      labels: {
        show: true,
        last_level: !showElasticChartsOptions,
        values: true,
        valuesFormat: _common.ValueFormats.PERCENT,
        percentDecimals: _common2.DEFAULT_PERCENT_DECIMALS,
        truncate: 100,
        position: _common.LabelPositions.DEFAULT
      }
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionsTemplate: (0, _components.getPieOptions)({
      showElasticChartsOptions,
      palettes
    }),
    schemas: [{
      group: _public.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypePie.pie.metricTitle', {
        defaultMessage: 'Slice size'
      }),
      min: 1,
      max: 1,
      aggFilter: ['sum', 'count', 'cardinality', 'top_hits'],
      defaults: [{
        schema: 'metric',
        type: 'count'
      }]
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'segment',
      title: _i18n.i18n.translate('visTypePie.pie.segmentTitle', {
        defaultMessage: 'Split slices'
      }),
      min: 0,
      max: Infinity,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'split',
      title: _i18n.i18n.translate('visTypePie.pie.splitTitle', {
        defaultMessage: 'Split chart'
      }),
      mustBeFirst: true,
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }]
  },
  hierarchicalData: true,
  requiresSearch: true,
  navigateToLens: async (vis, timefilter) => {
    const {
      convertToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
    return vis ? convertToLens(vis, timefilter) : null;
  },
  getExpressionVariables: async (vis, timeFilter) => {
    const {
      convertToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertToLens(vis, timeFilter) : null)
    };
  }
});
exports.getPieVisTypeDefinition = getPieVisTypeDefinition;