"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToLens = void 0;
var _public = require("@kbn/visualizations-plugin/public");
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _uuid = require("uuid");
var _services = require("../services");
var _configurations = require("./configurations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertToLens = async (vis, timefilter) => {
  var _vis$data$indexPatter;
  if (!timefilter) {
    return null;
  }
  const dataViews = (0, _services.getDataViewsStart)();
  const dataView = await (0, _public.getDataViewByIndexPatternId)((_vis$data$indexPatter = vis.data.indexPattern) === null || _vis$data$indexPatter === void 0 ? void 0 : _vis$data$indexPatter.id, dataViews);
  if (!dataView) {
    return null;
  }
  const {
    getColumnsFromVis,
    convertToFiltersColumn
  } = await _public.convertToLensModule;
  const layers = getColumnsFromVis(vis, timefilter, dataView, {
    buckets: ['segment'],
    splits: ['group'],
    unsupported: ['split_row', 'split_column']
  });
  if (layers === null) {
    return null;
  }
  const [layerConfig] = layers;
  const xColumn = layerConfig.columns.find(({
    isBucketed,
    isSplit
  }) => isBucketed && !isSplit);
  const xAxisColumn = xColumn !== null && xColumn !== void 0 ? xColumn : convertToFiltersColumn((0, _uuid.v4)(), {
    filters: [{
      input: {
        language: 'lucene',
        query: '*'
      }
    }]
  });
  if ((xColumn === null || xColumn === void 0 ? void 0 : xColumn.columnId) !== (xAxisColumn === null || xAxisColumn === void 0 ? void 0 : xAxisColumn.columnId)) {
    layerConfig.buckets.all.push(xAxisColumn.columnId);
    layerConfig.columns.push(xAxisColumn);
  }
  const yColumn = layerConfig.columns.find(({
    isBucketed,
    isSplit
  }) => isBucketed && isSplit);
  if (!layerConfig.buckets.all.length || layerConfig.metrics.length > 1) {
    return null;
  }
  const layerId = (0, _uuid.v4)();
  const indexPatternId = dataView.id;
  const configuration = await (0, _configurations.getConfiguration)(layerId, vis, {
    metrics: layerConfig.metrics,
    buckets: [xAxisColumn.columnId, yColumn === null || yColumn === void 0 ? void 0 : yColumn.columnId].filter(c => Boolean(c))
  });
  return {
    type: 'lnsHeatmap',
    layers: [{
      indexPatternId,
      layerId,
      columns: layerConfig.columns.map(_convert_to_lens.excludeMetaFromColumn),
      columnOrder: [],
      ignoreGlobalFilters: false
    }],
    configuration,
    indexPatternIds: [indexPatternId]
  };
};
exports.convertToLens = convertToLens;