"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfiguration = void 0;
var _palette = require("./palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getConfiguration = async (layerId, vis, {
  metrics,
  buckets
}) => {
  var _uiState$get, _params$valueAxes$0$l, _params$valueAxes;
  const [valueAccessor] = metrics;
  const [xAccessor, yAccessor] = buckets;
  const {
    params,
    uiState
  } = vis;
  const state = (_uiState$get = uiState.get('vis', {})) !== null && _uiState$get !== void 0 ? _uiState$get : {};
  const palette = await (0, _palette.getPaletteForHeatmap)(params);
  return {
    layerId,
    layerType: 'data',
    shape: 'heatmap',
    legend: {
      type: 'heatmap_legend',
      isVisible: state.legendOpen,
      position: params.legendPosition
    },
    gridConfig: {
      type: 'heatmap_grid',
      isCellLabelVisible: (_params$valueAxes$0$l = (_params$valueAxes = params.valueAxes) === null || _params$valueAxes === void 0 ? void 0 : _params$valueAxes[0].labels.show) !== null && _params$valueAxes$0$l !== void 0 ? _params$valueAxes$0$l : false,
      isXAxisLabelVisible: true,
      isYAxisLabelVisible: true,
      isYAxisTitleVisible: true,
      isXAxisTitleVisible: true
    },
    valueAccessor,
    xAccessor,
    yAccessor,
    palette: palette ? {
      ...palette,
      accessor: valueAccessor
    } : undefined
  };
};
exports.getConfiguration = getConfiguration;