"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfiguration = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getConfiguration = (layerId, params, palette, {
  metricAccessor,
  minAccessor,
  maxAccessor
}) => {
  const showLabels = Boolean(params.gauge.labels.show);
  return {
    layerId,
    layerType: 'data',
    palette,
    metricAccessor,
    minAccessor,
    maxAccessor,
    shape: 'horizontalBullet',
    ticksPosition: 'bands',
    labelMajorMode: 'auto',
    colorMode: palette ? 'palette' : 'none',
    labelMinor: showLabels ? params.gauge.style.subText : undefined
  };
};
exports.getConfiguration = getConfiguration;