"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  useEditorReducer: true
};
exports.useEditorReducer = useEditorReducer;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reducers = require("./reducers");
var _constants = require("./constants");
var _editor_form_state = require("./editor_form_state");
Object.keys(_editor_form_state).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _editor_form_state[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _editor_form_state[key];
    }
  });
});
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function useEditorReducer(vis, eventEmitter) {
  const {
    services
  } = (0, _public.useKibana)();
  const [state, dispatch] = (0, _react.useReducer)((0, _reducers.createEditorStateReducer)(services.data.search), vis, _reducers.initEditorState);
  const wrappedDispatch = (0, _react.useCallback)(action => {
    dispatch(action);
    eventEmitter.emit('dirtyStateChange', {
      isDirty: action.type !== _constants.EditorStateActionTypes.DISCARD_CHANGES
    });
  }, [eventEmitter]);
  return [state, wrappedDispatch];
}