"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorDataTab = DefaultEditorDataTab;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _agg_group = require("../agg_group");
var _state = require("./state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DefaultEditorDataTab({
  dispatch,
  formIsTouched,
  metricAggs,
  schemas,
  state,
  setTouched,
  setValidity,
  setStateValue,
  timeRange
}) {
  const lastParentPipelineAgg = (0, _react.useMemo)(() => (0, _lodash.findLast)(metricAggs, ({
    type
  }) => type.subtype === _public.search.aggs.parentPipelineType), [metricAggs]);
  const lastParentPipelineAggTitle = lastParentPipelineAgg && lastParentPipelineAgg.type.title;
  const addSchema = (0, _react.useCallback)(schema => dispatch((0, _state.addNewAgg)(schema)), [dispatch]);
  const onAggRemove = (0, _react.useCallback)(aggId => dispatch((0, _state.removeAgg)(aggId, schemas.all || [])), [dispatch, schemas]);
  const onReorderAggs = (0, _react.useCallback)((...props) => dispatch((0, _state.reorderAggs)(...props)), [dispatch]);
  const onAggParamValueChange = (0, _react.useCallback)((...props) => dispatch((0, _state.setAggParamValue)(...props)), [dispatch]);
  const onAggTypeChange = (0, _react.useCallback)((...props) => dispatch((0, _state.changeAggType)(...props)), [dispatch]);
  const onToggleEnableAgg = (0, _react.useCallback)((...props) => dispatch((0, _state.toggleEnabledAgg)(...props)), [dispatch]);
  const commonProps = {
    addSchema,
    formIsTouched,
    lastParentPipelineAggTitle,
    metricAggs,
    state,
    reorderAggs: onReorderAggs,
    setAggParamValue: onAggParamValueChange,
    setStateParamValue: setStateValue,
    onAggTypeChange,
    onToggleEnableAgg,
    setValidity,
    setTouched,
    removeAgg: onAggRemove
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_agg_group.DefaultEditorAggGroup, (0, _extends2.default)({
    groupName: _public.AggGroupNames.Metrics,
    schemas: schemas.metrics
  }, commonProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_agg_group.DefaultEditorAggGroup, (0, _extends2.default)({
    groupName: _public.AggGroupNames.Buckets,
    schemas: schemas.buckets,
    timeRange: timeRange
  }, commonProps)));
}