"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_OPTIONS = void 0;
exports.MetricAggParamEditor = MetricAggParamEditor;
exports.aggFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const aggFilter = ['!top_hits', '!top_metrics', '!percentiles', '!percentile_ranks', '!median', '!std_dev'];
exports.aggFilter = aggFilter;
const EMPTY_VALUE = 'EMPTY_VALUE';
const DEFAULT_OPTIONS = [{
  text: '',
  value: EMPTY_VALUE,
  hidden: true
}];
exports.DEFAULT_OPTIONS = DEFAULT_OPTIONS;
function MetricAggParamEditor({
  agg,
  value,
  showValidation,
  setValue,
  setValidity,
  setTouched,
  metricAggs = []
}) {
  const label = _i18n.i18n.translate('visDefaultEditor.controls.metricLabel', {
    defaultMessage: 'Metric'
  });
  const isValid = !!value;
  (0, _utils.useValidation)(setValidity, isValid);
  (0, _utils.useFallbackMetric)(setValue, aggFilter, metricAggs, value);
  const filteredMetrics = (0, _react.useMemo)(() => metricAggs.filter(respAgg => respAgg.type.name !== agg.type.name), [metricAggs, agg.type.name]);
  const options = (0, _utils.useAvailableOptions)(aggFilter, filteredMetrics, DEFAULT_OPTIONS);
  const onChange = (0, _react.useCallback)(ev => setValue(ev.target.value), [setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation && !isValid,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    fullWidth: true,
    options: options,
    value: value || EMPTY_VALUE,
    onChange: onChange,
    isInvalid: showValidation && !isValid,
    onBlur: setTouched,
    "data-test-subj": `visEditorSubAggMetric${agg.id}`
  }));
}