"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaxBarsParamEditor = MaxBarsParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const autoPlaceholder = _i18n.i18n.translate('visDefaultEditor.controls.maxBars.autoPlaceholder', {
  defaultMessage: 'Auto'
});
const label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visDefaultEditor.controls.maxBars.maxBarsLabel",
  defaultMessage: "Max bars"
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  position: "right",
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.maxBars.maxBarsHelpText",
    defaultMessage: "Intervals will be selected automatically based on the available data. The maximum number of bars can never be greater than the Advanced Setting's {histogramMaxBars}",
    values: {
      histogramMaxBars: _public2.UI_SETTINGS.HISTOGRAM_MAX_BARS
    }
  }),
  type: "questionInCircle"
}));
function MaxBarsParamEditor({
  disabled,
  iconTip,
  value,
  setValue,
  showValidation,
  setValidity,
  setTouched
}) {
  var _services$uiSettings;
  const {
    services
  } = (0, _public.useKibana)();
  const uiSettingMaxBars = (_services$uiSettings = services.uiSettings) === null || _services$uiSettings === void 0 ? void 0 : _services$uiSettings.get(_public2.UI_SETTINGS.HISTOGRAM_MAX_BARS);
  const isValid = disabled || value === undefined || value === '' || Number(value) > 0 || value < uiSettingMaxBars;
  (0, _react.useEffect)(() => {
    setValidity(isValid);
  }, [isValid, setValidity]);
  const onChange = (0, _react.useCallback)(ev => setValue(ev.target.value === '' ? '' : parseFloat(ev.target.value)), [setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: value || '',
    placeholder: autoPlaceholder,
    onChange: onChange,
    min: 1,
    fullWidth: true,
    compressed: true,
    max: uiSettingMaxBars,
    isInvalid: showValidation ? !isValid : false,
    onBlur: setTouched,
    disabled: disabled,
    "data-test-subj": "maxBarsParamEditor"
  }));
}