"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetcher = useFetcher;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _create_call_apm_api = require("../services/rest/create_call_apm_api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDetailsFromErrorResponse(error) {
  var _error$body$message, _error$body, _error$response, _error$response2, _error$response3;
  const message = (_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.statusText;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, message, " (", (_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.status, ")", /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.ux.fetcher.error.url', {
    defaultMessage: `URL`
  })), (_error$response3 = error.response) === null || _error$response3 === void 0 ? void 0 : _error$response3.url);
}
const createAutoAbortedAPMClient = signal => {
  return (endpoint, options) => {
    return (0, _create_call_apm_api.callApmApi)(endpoint, {
      ...options,
      signal
    });
  };
};

// fetcher functions can return undefined OR a promise. Previously we had a more simple type
// but it led to issues when using object destructuring with default values
function useFetcher(fn, fnDeps, options = {}) {
  const {
    notifications
  } = (0, _public.useKibana)();
  const {
    preservePreviousData = true,
    showToastOnError = true
  } = options;
  const [result, setResult] = (0, _react.useState)({
    data: undefined,
    status: _public2.FETCH_STATUS.NOT_INITIATED
  });
  const [counter, setCounter] = (0, _react.useState)(0);
  const {
    addInspectorRequest
  } = (0, _public2.useInspectorContext)();
  (0, _react.useEffect)(() => {
    let controller = new AbortController();
    async function doFetch() {
      controller.abort();
      controller = new AbortController();
      const signal = controller.signal;
      const promise = fn(createAutoAbortedAPMClient(signal));
      // if `fn` doesn't return a promise it is a signal that data fetching was not initiated.
      // This can happen if the data fetching is conditional (based on certain inputs).
      // In these cases it is not desirable to invoke the global loading spinner, or change the status to success
      if (!promise) {
        return;
      }
      setResult(prevResult => ({
        data: preservePreviousData ? prevResult.data : undefined,
        // preserve data from previous state while loading next state
        status: _public2.FETCH_STATUS.LOADING,
        error: undefined
      }));
      try {
        const data = await promise;
        // when http fetches are aborted, the promise will be rejected
        // and this code is never reached. For async operations that are
        // not cancellable, we need to check whether the signal was
        // aborted before updating the result.
        if (!signal.aborted) {
          setResult({
            data,
            status: _public2.FETCH_STATUS.SUCCESS,
            error: undefined
          });
        }
      } catch (e) {
        const err = e;
        if (!signal.aborted) {
          const errorDetails = 'response' in err ? getDetailsFromErrorResponse(err) : err.message;
          if (showToastOnError) {
            notifications.toasts.danger({
              title: _i18n.i18n.translate('xpack.ux.fetcher.error.title', {
                defaultMessage: `Error while fetching resource`
              }),
              body: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.ux.fetcher.error.status', {
                defaultMessage: `Error`
              })), errorDetails)
            });
          }
          setResult({
            data: undefined,
            status: _public2.FETCH_STATUS.FAILURE,
            error: e
          });
        }
      }
    }
    doFetch();
    return () => {
      controller.abort();
    };
    /* eslint-disable react-hooks/exhaustive-deps */
  }, [counter, preservePreviousData, showToastOnError, ...fnDeps
  /* eslint-enable react-hooks/exhaustive-deps */]);

  (0, _react.useEffect)(() => {
    if (result.error) {
      var _result$error$body;
      addInspectorRequest({
        ...result,
        data: (_result$error$body = result.error.body) === null || _result$error$body === void 0 ? void 0 : _result$error$body.attributes
      });
    } else {
      addInspectorRequest(result);
    }
  }, [addInspectorRequest, result]);
  return (0, _react.useMemo)(() => {
    return {
      ...result,
      refetch: () => {
        // this will invalidate the deps to `useEffect` and will result in a new request
        setCounter(count => count + 1);
      }
    };
  }, [result]);
}