"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataView = useDataView;
var _react = require("react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _csm_shared_context = require("../csm_shared_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDataView() {
  const {
    dataView
  } = (0, _react.useContext)(_csm_shared_context.CsmSharedContext);
  const [dataViewTitle, setDataViewTitle] = (0, _useLocalStorage.default)('uxAppDataViewTitle', '');
  const updatedDataViewTitle = dataView === null || dataView === void 0 ? void 0 : dataView.title;
  (0, _react.useEffect)(() => {
    setDataViewTitle(updatedDataViewTitle);
  }, [setDataViewTitle, updatedDataViewTitle]);
  return {
    dataViewTitle,
    dataView
  };
}