"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocalUIFilters = LocalUIFilters;
exports.getExcludedName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/exploratory-view-plugin/public");
var _use_local_uifilters = require("../hooks/use_local_uifilters");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _url_filter = require("../url_filter");
var _selected_filters = require("./selected_filters");
var _use_data_view = require("./use_data_view");
var _queries = require("./queries");
var _use_ux_url_params = require("../../../../context/url_params_context/use_ux_url_params");
var _ux_ui_filter = require("../../../../../common/ux_ui_filter");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _transaction_types = require("../../../../../common/transaction_types");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterNames = ['location', 'device', 'os', 'browser'];
const getExcludedName = filterName => {
  return `${filterName}Excluded`;
};
exports.getExcludedName = getExcludedName;
const RUM_DATA_FILTERS = [{
  term: {
    [_elasticsearch_fieldnames.TRANSACTION_TYPE]: _transaction_types.TRANSACTION_PAGE_LOAD
  }
}];
function LocalUIFilters() {
  const {
    dataViewTitle,
    dataView
  } = (0, _use_data_view.useDataView)();
  const {
    filters = [],
    setFilterValue,
    invertFilter,
    clearValues
  } = (0, _use_local_uifilters.useLocalUIFilters)({
    filterNames: _ux_ui_filter.uxLocalUIFilterNames.filter(name => !['serviceName'].includes(name))
  });
  const {
    urlParams: {
      start,
      end,
      serviceName,
      environment
    }
  } = (0, _use_ux_url_params.useUxUrlParams)();
  const getFilters = (0, _react.useMemo)(() => {
    const dataFilters = [...RUM_DATA_FILTERS, ...(0, _queries.environmentQuery)(environment || _environment_filter_values.ENVIRONMENT_ALL.value)];
    if (serviceName) {
      dataFilters.push({
        term: {
          [_elasticsearch_fieldnames.SERVICE_NAME]: serviceName
        }
      });
    }
    return dataFilters;
  }, [environment, serviceName]);
  const {
    isSmall
  } = (0, _use_breakpoints.useBreakpoints)();
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.ux.localFiltersTitle', {
    defaultMessage: 'Filters'
  })));
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_url_filter.URLFilter, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true
  }, filterNames.map(filterName => {
    var _filters$find, _filters$find2;
    return /*#__PURE__*/_react.default.createElement(_public.FieldValueSuggestions, {
      key: filterName,
      sourceField: _ux_ui_filter.uxFiltersByName[filterName].fieldName,
      dataViewTitle: dataViewTitle,
      label: _ux_ui_filter.uxFiltersByName[filterName].title,
      asCombobox: false,
      selectedValue: (_filters$find = filters.find(ft => ft.name === filterName && !ft.excluded)) === null || _filters$find === void 0 ? void 0 : _filters$find.value,
      excludedValue: (_filters$find2 = filters.find(ft => ft.name === getExcludedName(filterName) && ft.excluded)) === null || _filters$find2 === void 0 ? void 0 : _filters$find2.value,
      asFilterButton: true,
      onChange: (values, excludedValues) => {
        setFilterValue(filterName, values || []);
        setFilterValue(getExcludedName(filterName), excludedValues || []);
      },
      filters: getFilters,
      time: {
        from: start,
        to: end
      }
    });
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_selected_filters.SelectedFilters, {
    filters: filters,
    onChange: (name, values) => {
      setFilterValue(name, values);
    },
    clearValues: clearValues,
    invertFilter: invertFilter,
    indexPattern: dataView
  }));
  return isSmall ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: 'uxFilterAccordion',
    buttonContent: title
  }, content) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content);
}