"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsageCollectionPlugin = void 0;
exports.isUnauthenticated = isUnauthenticated;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _analytics = require("@kbn/analytics");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _analyticsCollectionUtils = require("@kbn/analytics-collection-utils");
var _services = require("./services");
var _track_application_view = require("./components/track_application_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** Public's setup APIs exposed by the UsageCollection Service **/

/** Public's start APIs exposed by the UsageCollection Service **/

function isUnauthenticated(http) {
  const {
    anonymousPaths
  } = http;
  return anonymousPaths.isAnonymous(window.location.pathname);
}
class UsageCollectionPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "applicationUsageTracker", void 0);
    (0, _defineProperty2.default)(this, "subscriptions", []);
    (0, _defineProperty2.default)(this, "reporter", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = initializerContext.config.get();
  }
  setup({
    http
  }) {
    const localStorage = new _public.Storage(window.localStorage);
    const debug = this.config.uiCounters.debug;
    this.reporter = (0, _services.createReporter)({
      localStorage,
      debug,
      fetch: http
    });
    this.applicationUsageTracker = new _analytics.ApplicationUsageTracker(this.reporter);
    const applicationUsageTracker = this.getPublicApplicationUsageTracker();
    return {
      components: {
        ApplicationUsageTrackingProvider: props => /*#__PURE__*/_react.default.createElement(_track_application_view.ApplicationUsageContext.Provider, {
          value: applicationUsageTracker
        }, props.children)
      },
      reportUiCounter: this.reporter.reportUiCounter
    };
  }
  start({
    http,
    application
  }, {
    screenshotMode
  }) {
    if (!this.reporter || !this.applicationUsageTracker) {
      throw new Error('Usage collection reporter not set up correctly');
    }
    if (this.config.uiCounters.enabled && !isUnauthenticated(http) && !screenshotMode.isScreenshotMode() && !(0, _analyticsCollectionUtils.isSyntheticsMonitor)()) {
      this.reporter.start();
      this.applicationUsageTracker.start();
      this.subscriptions = (0, _services.trackApplicationUsageChange)(application.currentAppId$, this.applicationUsageTracker);
    }
    this.reporter.reportUserAgent('kibana');
    return {
      reportUiCounter: this.reporter.reportUiCounter
    };
  }
  stop() {
    if (this.applicationUsageTracker) {
      this.applicationUsageTracker.stop();
      this.subscriptions.forEach(subscription => subscription.unsubscribe());
    }
  }
  getPublicApplicationUsageTracker() {
    // Using this.applicationUsageTracker! because this private method is only called once it's initialised
    return {
      trackApplicationViewUsage: this.applicationUsageTracker.trackApplicationViewUsage.bind(this.applicationUsageTracker),
      flushTrackedView: this.applicationUsageTracker.flushTrackedView.bind(this.applicationUsageTracker),
      updateViewClickCounter: this.applicationUsageTracker.updateViewClickCounter.bind(this.applicationUsageTracker)
    };
  }
}
exports.UsageCollectionPlugin = UsageCollectionPlugin;