"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedObjectsAdapter = exports.registerUptimeSavedObjects = void 0;
var _server = require("@kbn/core/server");
var _settings = require("../../../constants/settings");
var _uptime_settings = require("./uptime_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUptimeSavedObjects = savedObjectsService => {
  savedObjectsService.registerType(_uptime_settings.umDynamicSettings);
};
exports.registerUptimeSavedObjects = registerUptimeSavedObjects;
const savedObjectsAdapter = {
  config: null,
  getUptimeDynamicSettings: async client => {
    try {
      var _obj$attributes;
      const obj = await client.get(_uptime_settings.umDynamicSettings.name, _uptime_settings.settingsObjectId);
      return (_obj$attributes = obj === null || obj === void 0 ? void 0 : obj.attributes) !== null && _obj$attributes !== void 0 ? _obj$attributes : _settings.DYNAMIC_SETTINGS_DEFAULT_ATTRIBUTES;
    } catch (getErr) {
      const config = savedObjectsAdapter.config;
      if (_server.SavedObjectsErrorHelpers.isNotFoundError(getErr)) {
        if (config !== null && config !== void 0 && config.index) {
          return {
            ..._settings.DYNAMIC_SETTINGS_DEFAULT_ATTRIBUTES,
            heartbeatIndices: config.index
          };
        }
        return _settings.DYNAMIC_SETTINGS_DEFAULT_ATTRIBUTES;
      }
      throw getErr;
    }
  },
  setUptimeDynamicSettings: async (client, settings) => {
    const newObj = await client.create(_uptime_settings.umDynamicSettings.name, settings, {
      id: _uptime_settings.settingsObjectId,
      overwrite: true
    });
    return newObj.attributes;
  }
};
exports.savedObjectsAdapter = savedObjectsAdapter;