"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchJourneyStepsEffect = fetchJourneyStepsEffect;
var _effects = require("redux-saga/effects");
var _journey = require("../actions/journey");
var _journey2 = require("../api/journey");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inFlightStepRequests = {};
function* fetchJourneyStepsEffect() {
  yield (0, _effects.takeEvery)(_journey.getJourneySteps, function* (action) {
    if (inFlightStepRequests[action.payload.checkGroup]) return;
    try {
      inFlightStepRequests[action.payload.checkGroup] = true;
      const response = yield (0, _effects.call)(_journey2.fetchJourneySteps, action.payload);
      yield (0, _effects.put)((0, _journey.getJourneyStepsSuccess)(response));
    } catch (e) {
      yield (0, _effects.put)((0, _journey.getJourneyStepsFail)({
        checkGroup: action.payload.checkGroup,
        error: e
      }));
    } finally {
      delete inFlightStepRequests[action.payload.checkGroup];
    }
  });
}