"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidCertVal = exports.SettingsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _selectors = require("../state/selectors");
var _dynamic_settings = require("../state/actions/dynamic_settings");
var _use_breadcrumbs = require("../hooks/use_breadcrumbs");
var _indices_form = require("../components/settings/indices_form");
var _certificate_form = require("../components/settings/certificate_form");
var Translations = _interopRequireWildcard(require("./translations"));
var _translations2 = require("../../../common/translations");
var _alert_defaults_form = require("../components/settings/alert_defaults_form");
var _settings_bottom_bar = require("../components/settings/settings_bottom_bar");
var _use_settings_errors = require("../components/settings/use_settings_errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidCertVal = val => {
  if (val === undefined || isNaN(val)) {
    return Translations.settings.mustBeNumber;
  }
  if (val <= 0) {
    return _translations2.VALUE_MUST_BE_GREATER_THAN_ZERO;
  }
  if (val % 1) {
    return _translations2.VALUE_MUST_BE_AN_INTEGER;
  }
};
exports.isValidCertVal = isValidCertVal;
const SettingsPage = () => {
  var _useKibana$services, _useKibana$services$a;
  const dss = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: Translations.settings.breadcrumbText
  }]);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch((0, _dynamic_settings.getDynamicSettings)());
  }, [dispatch]);
  const [formFields, setFormFields] = (0, _react.useState)(dss.settings ? {
    ...dss.settings
  } : null);
  if (!dss.loadError && formFields === null && dss.settings) {
    setFormFields(Object.assign({}, {
      ...dss.settings
    }));
  }
  const {
    errors: fieldErrors,
    isFormDirty
  } = (0, _use_settings_errors.useSettingsErrors)(formFields);
  const isFormValid = !(fieldErrors && Object.values(fieldErrors).find(v => !!v));
  const onChangeFormField = (0, _react.useCallback)(changedField => {
    if (formFields) {
      setFormFields({
        ...formFields,
        ...changedField
      });
    }
  }, [formFields]);
  const onApply = event => {
    event.preventDefault();
    if (formFields) {
      dispatch((0, _dynamic_settings.setDynamicSettings)(formFields));
    }
  };
  const resetForm = () => setFormFields(dss.settings ? {
    ...dss.settings
  } : null);
  const canEdit = !!((_useKibana$services = (0, _public.useKibana)().services) !== null && _useKibana$services !== void 0 && (_useKibana$services$a = _useKibana$services.application) !== null && _useKibana$services$a !== void 0 && _useKibana$services$a.capabilities.uptime.configureSettings) || false;
  const isFormDisabled = dss.loading || !canEdit;
  const cannotEditNotice = canEdit ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: Translations.settings.editNoticeTitle
  }, Translations.settings.editNoticeText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, cannotEditNotice)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: "settings-form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_indices_form.IndicesForm, {
    loading: dss.loading,
    onChange: onChangeFormField,
    formFields: formFields,
    fieldErrors: fieldErrors,
    isDisabled: isFormDisabled
  }), /*#__PURE__*/_react.default.createElement(_alert_defaults_form.AlertDefaultsForm, {
    loading: dss.loading,
    formFields: formFields,
    onChange: onChangeFormField,
    fieldErrors: fieldErrors,
    isDisabled: isFormDisabled
  }), /*#__PURE__*/_react.default.createElement(_certificate_form.CertificateExpirationForm, {
    loading: dss.loading,
    onChange: onChangeFormField,
    formFields: formFields,
    fieldErrors: fieldErrors,
    isDisabled: isFormDisabled
  }))))), /*#__PURE__*/_react.default.createElement(_settings_bottom_bar.SettingsActionBarPortal, {
    onApply: onApply,
    isFormDirty: isFormDirty,
    isFormDisabled: isFormDisabled,
    isFormValid: isFormValid,
    onCancel: resetForm,
    errors: fieldErrors
  }));
};
exports.SettingsPage = SettingsPage;