"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegratedAppAvailability = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIntegratedAppAvailability = (capabilities, integratedApps) => {
  return integratedApps.reduce((supportedSolutions, solutionName) => {
    supportedSolutions[solutionName] = capabilities[solutionName] && capabilities[solutionName].show === true;
    return supportedSolutions;
  }, {});
};
exports.getIntegratedAppAvailability = getIntegratedAppAvailability;