"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddConnectorFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _alerts = require("../../state/alerts/alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddConnectorFlyout = ({
  focusInput,
  isDisabled
}) => {
  const [addFlyoutVisible, setAddFlyoutVisibility] = (0, _react.useState)(false);
  const {
    services: {
      application,
      triggersActionsUi: {
        getAddConnectorFlyout
      }
    }
  } = (0, _public.useKibana)();
  const canEdit = !!(application !== null && application !== void 0 && application.capabilities.actions.save);
  const dispatch = (0, _reactRedux.useDispatch)();
  const ConnectorAddFlyout = (0, _react.useMemo)(() => getAddConnectorFlyout({
    onClose: () => {
      dispatch(_alerts.getConnectorsAction.get());
      setAddFlyoutVisibility(false);
      focusInput();
    },
    featureId: 'uptime'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, addFlyoutVisible ? ConnectorAddFlyout : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "createConnectorButton",
    onClick: () => setAddFlyoutVisibility(true),
    size: "s",
    isDisabled: isDisabled || !canEdit
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.alerts.settings.addConnector",
    defaultMessage: "Add connector"
  })));
};
exports.AddConnectorFlyout = AddConnectorFlyout;