"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _charts = require("../../common/charts");
var _chart_wrapper = require("../../common/charts/chart_wrapper");
var _snapshot_heading = require("./snapshot_heading");
var _use_snap_shot = require("./use_snap_shot");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SNAPSHOT_CHART_HEIGHT = 144;
/**
 * This component visualizes a KPI and histogram chart to help users quickly
 * glean the status of their uptime environment.
 * @param props the props required by the component
 */
const SnapshotComponent = ({
  height
}) => {
  const {
    count,
    loading
  } = (0, _use_snap_shot.useSnapShotCount)();
  return /*#__PURE__*/_react.default.createElement(_chart_wrapper.ChartWrapper, {
    loading: loading,
    height: height
  }, /*#__PURE__*/_react.default.createElement(_snapshot_heading.SnapshotHeading, {
    total: count.total
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_charts.DonutChart, {
    up: count.up,
    down: count.down,
    height: SNAPSHOT_CHART_HEIGHT
  }));
};
exports.SnapshotComponent = SnapshotComponent;