"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorListComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _monitor_status_column = require("./columns/monitor_status_column");
var _charts = require("../../common/charts");
var _overview_page_link = require("./overview_page_link");
var labels = _interopRequireWildcard(require("./translations"));
var _monitor_list_page_size_select = require("./monitor_list_page_size_select");
var _list_drawer_container = require("./monitor_list_drawer/list_drawer_container");
var _cert_status_column = require("./columns/cert_status_column");
var _monitor_list_header = require("./monitor_list_header");
var _translations2 = require("../../../../../common/translations/translations");
var _enable_alert = require("./columns/enable_alert");
var _monitor_name_col = require("./columns/monitor_name_col");
var _monitor_tags = require("../../common/monitor_tags");
var _use_monitor_histogram = require("./use_monitor_histogram");
var _no_items_message = require("./no_items_message");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorListComponent = ({
  filters,
  monitorList: {
    list,
    error,
    loading
  },
  pageSize,
  setPageSize,
  isPending
}) => {
  var _list$summaries, _list$nextPagePaginat, _list$prevPagePaginat, _error$body;
  const [expandedDrawerIds, updateExpandedDrawerIds] = (0, _react.useState)([]);
  const currentBreakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const [hideExtraColumns, setHideExtraColumns] = (0, _react.useState)(false);
  (0, _useDebounce.default)(() => {
    if (currentBreakpoint) {
      setHideExtraColumns(['m', 'l'].includes(currentBreakpoint));
    }
  }, 50, [currentBreakpoint]);
  const items = (_list$summaries = list.summaries) !== null && _list$summaries !== void 0 ? _list$summaries : [];
  const {
    histogramsById,
    minInterval
  } = (0, _use_monitor_histogram.useMonitorHistogram)({
    items
  });
  const nextPagePagination = (_list$nextPagePaginat = list.nextPagePagination) !== null && _list$nextPagePaginat !== void 0 ? _list$nextPagePaginat : '';
  const prevPagePagination = (_list$prevPagePaginat = list.prevPagePagination) !== null && _list$prevPagePaginat !== void 0 ? _list$prevPagePaginat : '';
  const toggleDrawer = id => {
    if (expandedDrawerIds.includes(id)) {
      updateExpandedDrawerIds(expandedDrawerIds.filter(p => p !== id));
    } else {
      updateExpandedDrawerIds([...expandedDrawerIds, id]);
    }
  };
  const getExpandedRowMap = () => {
    return expandedDrawerIds.reduce((map, id) => {
      return {
        ...map,
        [id]: /*#__PURE__*/_react.default.createElement(_list_drawer_container.MonitorListDrawer, {
          summary: items.find(({
            monitor_id: monitorId
          }) => monitorId === id)
        })
      };
    }, {});
  };
  const columns = [...[{
    align: 'left',
    field: 'state.summary.status',
    name: labels.STATUS_COLUMN_LABEL,
    mobileOptions: {
      fullWidth: true
    },
    render: (status, {
      state: {
        timestamp,
        summaryPings,
        error: summaryError
      }
    }) => {
      return /*#__PURE__*/_react.default.createElement(_monitor_status_column.MonitorListStatusColumn, {
        status: status,
        timestamp: timestamp,
        summaryPings: summaryPings !== null && summaryPings !== void 0 ? summaryPings : [],
        summaryError: summaryError
      });
    }
  }, {
    align: 'left',
    field: 'state.monitor.name',
    name: labels.NAME_COLUMN_LABEL,
    mobileOptions: {
      fullWidth: true
    },
    render: (_name, summary) => /*#__PURE__*/_react.default.createElement(_monitor_name_col.MonitorNameColumn, {
      summary: summary
    }),
    sortable: true
  }, {
    align: 'left',
    field: 'state.url.full',
    name: _translations2.URL_LABEL,
    width: '30%',
    render: url => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsColumnsLink",
      href: url,
      target: "_blank",
      color: "text",
      external: true
    }, url)
  }, {
    align: 'left',
    field: 'state.monitor.name',
    name: _translations2.TAGS_LABEL,
    width: '12%',
    render: (_name, summary) => /*#__PURE__*/_react.default.createElement(_monitor_tags.MonitorTags, {
      summary: summary
    })
  }, {
    align: 'left',
    field: 'state.tls.server.x509',
    name: labels.TLS_COLUMN_LABEL,
    render: x509 => /*#__PURE__*/_react.default.createElement(_cert_status_column.CertStatusColumn, {
      expiry: x509
    })
  }], ...(!hideExtraColumns ? [{
    align: 'left',
    field: 'monitor_id',
    name: labels.HISTORY_COLUMN_LABEL,
    mobileOptions: {
      show: false
    },
    render: monitorId => {
      var _histogramsById$monit;
      return /*#__PURE__*/_react.default.createElement(_charts.MonitorBarSeries, {
        histogramSeries: histogramsById === null || histogramsById === void 0 ? void 0 : (_histogramsById$monit = histogramsById[monitorId]) === null || _histogramsById$monit === void 0 ? void 0 : _histogramsById$monit.points,
        minInterval: minInterval
      });
    }
  }] : []), {
    align: 'center',
    field: '',
    name: labels.STATUS_ALERT_COLUMN,
    width: '100px',
    render: item => /*#__PURE__*/_react.default.createElement(_enable_alert.EnableMonitorAlert, {
      monitorId: item.monitor_id,
      selectedMonitor: item.state.summaryPings[0]
    })
  }, ...(!hideExtraColumns ? [{
    align: 'right',
    field: 'monitor_id',
    name: '',
    sortable: true,
    isExpander: true,
    width: '40px',
    render: id => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": labels.getExpandDrawerLabel(id),
        "data-test-subj": `xpack.synthetics.monitorList.${id}.expandMonitorDetail`,
        iconType: expandedDrawerIds.includes(id) ? 'arrowUp' : 'arrowDown',
        onClick: () => toggleDrawer(id)
      });
    }
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(WrapperPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_monitor_list_header.MonitorListHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "aria-label": labels.getDescriptionLabel(items.length),
    error: (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || (error === null || error === void 0 ? void 0 : error.message),
    loading: loading || isPending,
    isExpandable: true,
    hasActions: true,
    itemId: "monitor_id",
    itemIdToExpandedRowMap: getExpandedRowMap(),
    items: items,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_no_items_message.NoItemsMessage, {
      loading: Boolean(loading || isPending),
      filters: filters
    }),
    columns: columns,
    tableLayout: 'auto',
    rowProps: hideExtraColumns ? ({
      monitor_id: monitorId
    }) => ({
      onClick: () => toggleDrawer(monitorId),
      'aria-label': labels.getExpandDrawerLabel(monitorId)
    }) : ({
      monitor_id: monitorId
    }) => ({
      className: undefined
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_monitor_list_page_size_select.MonitorListPageSizeSelect, {
    size: pageSize,
    setSize: setPageSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_overview_page_link.OverviewPageLink, {
    dataTestSubj: "xpack.uptime.monitorList.prevButton",
    direction: "prev",
    pagination: prevPagePagination
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_overview_page_link.OverviewPageLink, {
    dataTestSubj: "xpack.uptime.monitorList.nextButton",
    direction: "next",
    pagination: nextPagePagination
  }))))));
};
exports.MonitorListComponent = MonitorListComponent;
const WrapperPanel = (0, _common.euiStyled)(_eui.EuiPanel)`
  &&&  {
  .refresh-row{
    background-color: #f0f4fb;
    -webkit-transition: background-color 3000ms linear;
    -ms-transition: background-color 3000ms linear;
    transition: background-color 3000ms linear;
    }
  }
`;