"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasFilters = exports.AlertMonitorStatusComponent = exports.AlertMonitorCount = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _monitor_expressions = require("../monitor_expressions");
var _add_filter_btn = require("./add_filter_btn");
var _old_alert_call_out = require("./old_alert_call_out");
var _availability_expression_select = require("../monitor_expressions/availability_expression_select");
var _query_bar = require("../alert_query_bar/query_bar");
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasFilters = filters => {
  if (!filters || Object.keys(filters).length === 0) {
    return false;
  }
  return Object.values(_constants.FILTER_FIELDS).some(f => filters[f].length);
};
exports.hasFilters = hasFilters;
const AlertMonitorStatusComponent = props => {
  var _ruleParams$filters;
  const {
    ruleParams,
    isOldAlert,
    setRuleParams,
    snapshotCount,
    snapshotLoading
  } = props;
  const alertFilters = (_ruleParams$filters = ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.filters) !== null && _ruleParams$filters !== void 0 ? _ruleParams$filters : {};
  const [newFilters, setNewFilters] = (0, _react.useState)(Object.keys(alertFilters).filter(f => alertFilters[f].length));
  const {
    search = ''
  } = (0, _hooks.useGetUrlParams)();
  (0, _react.useEffect)(() => {
    if (search) {
      setRuleParams('search', search);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onSearchChange = (0, _react.useCallback)(value => {
    setRuleParams('search', value);
  }, [setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_old_alert_call_out.OldAlertCallOut, {
    isOldAlert: isOldAlert
  }), /*#__PURE__*/_react.default.createElement(AlertMonitorCount, {
    count: snapshotCount,
    loading: snapshotLoading
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_query_bar.AlertQueryBar, {
    query: ruleParams.search || '',
    onChange: onSearchChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_add_filter_btn.AddFilterButton, {
    alertFilters: ruleParams.filters,
    newFilters: newFilters,
    onNewFilter: newFilter => {
      setNewFilters([...newFilters, newFilter]);
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_expressions.FiltersExpressionsSelect, {
    ruleParams: ruleParams,
    newFilters: newFilters,
    onRemoveFilter: removeFilter => {
      if (newFilters.includes(removeFilter)) {
        setNewFilters(newFilters.filter(item => item !== removeFilter));
      }
    },
    setRuleParams: setRuleParams,
    shouldUpdateUrl: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_monitor_expressions.StatusExpressionSelect, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams,
    hasFilters: hasFilters(ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.filters)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_availability_expression_select.AvailabilityExpressionSelect, {
    ruleParams: ruleParams,
    isOldAlert: isOldAlert,
    setRuleParams: setRuleParams,
    hasFilters: hasFilters(ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.filters)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.AlertMonitorStatusComponent = AlertMonitorStatusComponent;
const AlertMonitorCount = ({
  count,
  loading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "alertSnapShotCount"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.alerts.monitorStatus.monitorCallOut.title",
      defaultMessage: "This alert will apply to approximately {snapshotCount} monitors.",
      values: {
        snapshotCount: loading ? '...' : count
      }
    }), ' ', loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)),
    iconType: "iInCircle"
  });
};
exports.AlertMonitorCount = AlertMonitorCount;