"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallMarkerIcon = WaterfallMarkerIcon;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _waterfall_marker_trend = require("./waterfall_marker_trend");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function WaterfallMarkerIcon({
  field,
  label
}) {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  if (!field) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": _i18n.i18n.translate('xpack.uptime.synthetics.markers.noFieldIcon.label', {
        defaultMessage: 'An icon indicating that this marker has no field associated with it'
      }),
      type: "dot",
      size: "l"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    anchorPosition: "downLeft",
    panelStyle: {
      paddingBottom: 0,
      paddingLeft: 4
    },
    zIndex: 100,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.uptime.synthetics.markers.openEmbeddableButton.label', {
        defaultMessage: 'Use this icon button to show metrics for this annotation marker.'
      }),
      iconType: "dot",
      iconSize: "l",
      color: "text",
      onClick: () => setIsOpen(prevState => !prevState)
    })
  }, /*#__PURE__*/_react.default.createElement(_waterfall_marker_trend.WaterfallMarkerTrend, {
    title: label,
    field: field
  }));
}