"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useWindowSize = _interopRequireDefault(require("react-use/lib/useWindowSize"));
var _waterfall_chart = require("../context/waterfall_chart");
var _styles = require("./styles");
var _constants = require("./constants");
var _sidebar = require("./sidebar");
var _legend = require("./legend");
var _use_bar_charts = require("./use_bar_charts");
var _waterfall_bar_chart = require("./waterfall_bar_chart");
var _waterfall_chart_fixed_axis = require("./waterfall_chart_fixed_axis");
var _network_requests_total = require("./network_requests_total");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaterfallChart = ({
  tickFormat,
  domain,
  barStyleAccessor,
  renderSidebarItem,
  renderLegendItem,
  renderFilter,
  renderFlyout,
  maxHeight = '800px',
  fullHeight = false
}) => {
  const {
    data,
    showOnlyHighlightedNetworkRequests,
    sidebarItems,
    legendItems,
    totalNetworkRequests,
    highlightedNetworkRequests,
    fetchedNetworkRequests
  } = (0, _waterfall_chart.useWaterfallContext)();
  const {
    width
  } = (0, _useWindowSize.default)();
  const chartWrapperDivRef = (0, _react.useRef)(null);
  const legendDivRef = (0, _react.useRef)(null);
  const [height, setHeight] = (0, _react.useState)(maxHeight);
  const shouldRenderSidebar = !!(sidebarItems && renderSidebarItem);
  const shouldRenderLegend = !!(legendItems && legendItems.length > 0 && renderLegendItem);
  (0, _react.useEffect)(() => {
    if (fullHeight && chartWrapperDivRef.current && legendDivRef.current) {
      const chartOffset = chartWrapperDivRef.current.getBoundingClientRect().top;
      const legendOffset = legendDivRef.current.getBoundingClientRect().height;
      setHeight(`calc(100vh - ${chartOffset + _constants.CHART_LEGEND_PADDING + legendOffset}px)`);
    }
  }, [chartWrapperDivRef, fullHeight, legendDivRef, width]);
  const chartsToDisplay = (0, _use_bar_charts.useBarCharts)({
    data
  });
  return /*#__PURE__*/_react.default.createElement(_styles.RelativeContainer, null, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartFixedTopContainer, null, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartTopContainer, {
    gutterSize: "none",
    responsive: false
  }, shouldRenderSidebar && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartFixedTopContainerSidebarCover, {
    paddingSize: "none",
    hasShadow: false
  }), /*#__PURE__*/_react.default.createElement(_network_requests_total.NetworkRequestsTotal, {
    totalNetworkRequests: totalNetworkRequests,
    highlightedNetworkRequests: highlightedNetworkRequests,
    fetchedNetworkRequests: fetchedNetworkRequests,
    showHighlightedNetworkRequests: showOnlyHighlightedNetworkRequests
  }), renderFilter && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartFilterContainer, null, renderFilter())), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartAxisOnlyContainer, {
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true,
    "data-test-subj": "axisOnlyWrapper"
  }, /*#__PURE__*/_react.default.createElement(_waterfall_chart_fixed_axis.WaterfallChartFixedAxis, {
    domain: domain,
    barStyleAccessor: barStyleAccessor,
    tickFormat: tickFormat
  })))), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartOuterContainer, {
    height: height,
    "data-test-subj": "waterfallOuterContainer",
    ref: chartWrapperDivRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false
  }, shouldRenderSidebar && /*#__PURE__*/_react.default.createElement(_sidebar.Sidebar, {
    items: sidebarItems,
    render: renderSidebarItem
  }), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartAxisOnlyContainer, {
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true,
    "data-test-subj": "dataOnlyWrapper"
  }, chartsToDisplay.map((chartData, ind) => /*#__PURE__*/_react.default.createElement(_waterfall_bar_chart.WaterfallBarChart, {
    index: ind,
    key: ind,
    chartData: chartData,
    domain: domain,
    barStyleAccessor: barStyleAccessor,
    tickFormat: tickFormat
  }))))), shouldRenderLegend && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartLegendContainer, {
    ref: legendDivRef
  }, /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    items: legendItems,
    render: renderLegendItem
  })), renderFlyout && renderFlyout());
};
exports.WaterfallChart = WaterfallChart;