"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallChartContainer = exports.NO_DATA_TEXT = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _network_events = require("../../../../../state/actions/network_events");
var _selectors = require("../../../../../state/selectors");
var _waterfall_chart_wrapper = require("./waterfall_chart_wrapper");
var _data_formatting = require("./data_formatting");
var _use_step_waterfall_metrics = require("../use_step_waterfall_metrics");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_DATA_TEXT = _i18n.i18n.translate('xpack.uptime.synthetics.stepDetail.waterfallNoData', {
  defaultMessage: 'No waterfall data could be found for this step'
});
exports.NO_DATA_TEXT = NO_DATA_TEXT;
const WaterfallChartContainer = ({
  checkGroup,
  stepIndex,
  activeStep
}) => {
  var _networkEvents2, _networkEvents$events;
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    if (checkGroup && stepIndex) {
      dispatch((0, _network_events.getNetworkEvents)({
        checkGroup,
        stepIndex
      }));
    }
  }, [dispatch, stepIndex, checkGroup]);
  const _networkEvents = (0, _reactRedux.useSelector)(_selectors.networkEventsSelector);
  const networkEvents = (_networkEvents2 = _networkEvents[checkGroup !== null && checkGroup !== void 0 ? checkGroup : '']) === null || _networkEvents2 === void 0 ? void 0 : _networkEvents2[stepIndex];
  const waterfallLoaded = networkEvents && !networkEvents.loading;
  const isWaterfallSupported = networkEvents === null || networkEvents === void 0 ? void 0 : networkEvents.isWaterfallSupported;
  const hasEvents = (networkEvents === null || networkEvents === void 0 ? void 0 : (_networkEvents$events = networkEvents.events) === null || _networkEvents$events === void 0 ? void 0 : _networkEvents$events.length) > 0;
  const {
    metrics
  } = (0, _use_step_waterfall_metrics.useStepWaterfallMetrics)({
    checkGroup,
    stepIndex,
    hasNavigationRequest: networkEvents === null || networkEvents === void 0 ? void 0 : networkEvents.hasNavigationRequest
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !waterfallLoaded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl",
    "aria-label": _i18n.i18n.translate('xpack.uptime.synthetics.stepDetail.waterfall.loading', {
      defaultMessage: 'Waterfall chart loading'
    })
  }))), waterfallLoaded && !hasEvents && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, NO_DATA_TEXT)))), waterfallLoaded && hasEvents && isWaterfallSupported && /*#__PURE__*/_react.default.createElement(_waterfall_chart_wrapper.WaterfallChartWrapper, {
    data: (0, _data_formatting.extractItems)(networkEvents.events),
    markerItems: metrics,
    total: networkEvents.total,
    activeStep: activeStep
  }), waterfallLoaded && hasEvents && !isWaterfallSupported && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.synthetics.stepDetail.waterfallUnsupported.title",
      defaultMessage: "Waterfall chart unavailable"
    }),
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.synthetics.stepDetail.waterfallUnsupported.description",
    defaultMessage: "The waterfall chart cannot be shown. You may be using an older version of the Synthetic Agent. Please check the version and consider upgrading."
  })));
};
exports.WaterfallChartContainer = WaterfallChartContainer;