"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailContainer = exports.NO_STEP_DATA = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_monitor_breadcrumb = require("./use_monitor_breadcrumb");
var _waterfall_chart_container = require("./waterfall/waterfall_chart_container");
var _step_detail_page = require("../../../../pages/synthetics/step_detail_page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_STEP_DATA = _i18n.i18n.translate('xpack.uptime.synthetics.stepDetail.noData', {
  defaultMessage: 'No data could be found for this step'
});
exports.NO_STEP_DATA = NO_STEP_DATA;
const StepDetailContainer = ({
  checkGroup,
  stepIndex
}) => {
  const {
    activeStep,
    journey
  } = (0, _step_detail_page.useStepDetailPage)();
  (0, _use_monitor_breadcrumb.useMonitorBreadcrumb)({
    details: journey === null || journey === void 0 ? void 0 : journey.details,
    activeStep,
    performanceBreakDownView: true
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (!journey || journey.loading) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  }))), journey && !activeStep && !journey.loading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, NO_STEP_DATA)))), journey && activeStep && !journey.loading && /*#__PURE__*/_react.default.createElement(_waterfall_chart_container.WaterfallChartContainer, {
    checkGroup: checkGroup,
    stepIndex: stepIndex,
    activeStep: activeStep
  }));
};
exports.StepDetailContainer = StepDetailContainer;