"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.breadcrumbService = exports.BreadcrumbService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  breadcrumbs: {
    overview: _i18n.i18n.translate('xpack.upgradeAssistant.breadcrumb.overviewLabel', {
      defaultMessage: 'Upgrade Assistant'
    }),
    esDeprecations: _i18n.i18n.translate('xpack.upgradeAssistant.breadcrumb.esDeprecationsLabel', {
      defaultMessage: 'Elasticsearch deprecation issues'
    }),
    esDeprecationLogs: _i18n.i18n.translate('xpack.upgradeAssistant.breadcrumb.esDeprecationLogsLabel', {
      defaultMessage: 'Elasticsearch deprecation logs'
    }),
    kibanaDeprecations: _i18n.i18n.translate('xpack.upgradeAssistant.breadcrumb.kibanaDeprecationsLabel', {
      defaultMessage: 'Kibana deprecation issues'
    })
  }
};
class BreadcrumbService {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbs", {
      overview: [{
        text: i18nTexts.breadcrumbs.overview
      }],
      esDeprecations: [{
        text: i18nTexts.breadcrumbs.overview,
        href: '/'
      }, {
        text: i18nTexts.breadcrumbs.esDeprecations
      }],
      esDeprecationLogs: [{
        text: i18nTexts.breadcrumbs.overview,
        href: '/'
      }, {
        text: i18nTexts.breadcrumbs.esDeprecationLogs
      }],
      kibanaDeprecations: [{
        text: i18nTexts.breadcrumbs.overview,
        href: '/'
      }, {
        text: i18nTexts.breadcrumbs.kibanaDeprecations
      }]
    });
    (0, _defineProperty2.default)(this, "setBreadcrumbsHandler", void 0);
  }
  setup(setBreadcrumbsHandler) {
    this.setBreadcrumbsHandler = setBreadcrumbsHandler;
  }
  setBreadcrumbs(type) {
    if (!this.setBreadcrumbsHandler) {
      throw new Error('Breadcrumb service has not been initialized');
    }
    const newBreadcrumbs = this.breadcrumbs[type] ? [...this.breadcrumbs[type]] : [...this.breadcrumbs.home];
    this.setBreadcrumbsHandler(newBreadcrumbs);
  }
}
exports.BreadcrumbService = BreadcrumbService;
const breadcrumbService = new BreadcrumbService();
exports.breadcrumbService = breadcrumbService;