"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _ui_metric = require("../../lib/ui_metric");
var _shared = require("../shared");
require("./_deprecation_details_flyout.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  closeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.closeButtonLabel', {
    defaultMessage: 'Close'
  }),
  quickResolveButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveButtonLabel', {
    defaultMessage: 'Quick resolve'
  }),
  retryQuickResolveButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.retryQuickResolveButtonLabel', {
    defaultMessage: 'Try again'
  }),
  resolvedButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.resolvedButtonLabel', {
    defaultMessage: 'Resolved'
  }),
  quickResolveInProgressButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveInProgressButtonLabel', {
    defaultMessage: 'Resolution in progress…'
  }),
  quickResolveCalloutTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveCalloutTitle",
    defaultMessage: "Click {quickResolve} to fix this issue automatically.",
    values: {
      quickResolve: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveText', {
        defaultMessage: 'Quick resolve'
      }))
    }
  }),
  quickResolveErrorTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveErrorTitle', {
    defaultMessage: 'Error resolving issue'
  }),
  manualFixTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.manualFixTitle', {
    defaultMessage: 'How to fix'
  })
};
const getQuickResolveButtonLabel = deprecationResolutionState => {
  if ((deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'in_progress') {
    return i18nTexts.quickResolveInProgressButtonLabel;
  }
  if ((deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'ok') {
    return i18nTexts.resolvedButtonLabel;
  }
  if (deprecationResolutionState !== null && deprecationResolutionState !== void 0 && deprecationResolutionState.resolveDeprecationError) {
    return i18nTexts.retryQuickResolveButtonLabel;
  }
  return i18nTexts.quickResolveButtonLabel;
};
const DeprecationDetailsFlyout = ({
  deprecation,
  closeFlyout,
  resolveDeprecation,
  deprecationResolutionState
}) => {
  const {
    documentationUrl,
    message,
    correctiveActions,
    title
  } = deprecation;
  const isCurrent = (deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.id) === deprecation.id;
  const isResolved = isCurrent && (deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'ok';
  const onResolveDeprecation = (0, _react.useCallback)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_KIBANA_QUICK_RESOLVE_CLICK);
    resolveDeprecation(deprecation);
  }, [deprecation, resolveDeprecation]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
    isCritical: deprecation.level === 'critical',
    isResolved: isResolved
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "kibanaDeprecationDetailsFlyoutTitle",
    className: "eui-textBreakWord"
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, (deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'fail' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.quickResolveErrorTitle,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "quickResolveError"
  }, deprecationResolutionState.resolveDeprecationError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textBreakWord"
  }, message), documentationUrl && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_shared.DeprecationFlyoutLearnMoreLink, {
    documentationUrl: documentationUrl
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !isResolved && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolveSection"
  }, correctiveActions.api && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.quickResolveCalloutTitle,
    color: "primary",
    iconType: "iInCircle",
    "data-test-subj": "quickResolveCallout"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), correctiveActions.manualSteps.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "manualStepsTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18nTexts.manualFixTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, correctiveActions.manualSteps.length === 1 ? /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "manualStep",
    className: "eui-textBreakWord"
  }, correctiveActions.manualSteps[0]) : /*#__PURE__*/_react.default.createElement("ol", {
    "data-test-subj": "manualStepsList"
  }, correctiveActions.manualSteps.map((step, stepIndex) => /*#__PURE__*/_react.default.createElement("li", {
    "data-test-subj": "manualStepsListItem",
    key: `step-${stepIndex}`,
    className: "upgResolveStep eui-textBreakWord"
  }, step))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left"
  }, i18nTexts.closeButtonLabel)), correctiveActions.api && !isResolved && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "resolveButton",
    onClick: onResolveDeprecation,
    isLoading: Boolean((deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'in_progress')
  }, getQuickResolveButtonLabel(deprecationResolutionState))))));
};
exports.DeprecationDetailsFlyout = DeprecationDetailsFlyout;