"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsDeprecationsTableCells = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _shared = require("../shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  manualCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.defaultDeprecation.manualCellLabel', {
    defaultMessage: 'Manual'
  }),
  manualCellTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.manualCellTooltipLabel', {
    defaultMessage: 'This issue needs to be resolved manually.'
  })
};
const EsDeprecationsTableCells = ({
  resolutionTableCell,
  fieldName,
  deprecation,
  openFlyout
}) => {
  var _deprecation$fieldNam;
  // "Status column"
  if (fieldName === 'isCritical') {
    return /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
      isCritical: deprecation.isCritical
    });
  }

  // "Issue" column
  if (fieldName === 'message') {
    var _deprecation$correcti, _deprecation$correcti2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": `deprecation-${(_deprecation$correcti = (_deprecation$correcti2 = deprecation.correctiveAction) === null || _deprecation$correcti2 === void 0 ? void 0 : _deprecation$correcti2.type) !== null && _deprecation$correcti !== void 0 ? _deprecation$correcti : 'default'}`,
      onClick: openFlyout
    }, deprecation.message);
  }

  // "Type" column
  if (fieldName === 'type') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants.DEPRECATION_TYPE_MAP[deprecation.type]);
  }

  // "Resolution column"
  if (fieldName === 'correctiveAction') {
    if (resolutionTableCell) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resolutionTableCell);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: i18nTexts.manualCellTooltipLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, i18nTexts.manualCellLabel));
  }

  // Default behavior: render value or empty string if undefined
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_deprecation$fieldNam = deprecation[fieldName]) !== null && _deprecation$fieldNam !== void 0 ? _deprecation$fieldNam : '');
};
exports.EsDeprecationsTableCells = EsDeprecationsTableCells;