"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.QueryBarMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _query_bar_menu_panels = require("./query_bar_menu_panels");
var _filter_editor_wrapper = require("./filter_editor_wrapper");
var _add_filter_popover = require("./add_filter_popover.styles");
var _filter_editor = require("../filter_bar/filter_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getFilterSetButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.filterSetButtonLabel', {
    defaultMessage: 'Query menu'
  }),
  getSavedQueryPopoverSaveChangesButtonText: () => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveChangesButtonText', {
    defaultMessage: 'Update query'
  })
};
exports.strings = strings;
function QueryBarMenuComponent({
  language,
  nonKqlMode,
  disableQueryLanguageSwitcher,
  dateRangeFrom,
  dateRangeTo,
  onQueryChange,
  onQueryBarSubmit,
  savedQueryService,
  saveAsNewQueryFormComponent,
  saveFormComponent,
  manageFilterSetComponent,
  hiddenPanelOptions,
  openQueryBarMenu,
  toggleFilterBarMenuPopover,
  onFiltersUpdated,
  filters,
  query,
  savedQuery,
  onClearSavedQuery,
  showQueryInput,
  showFilterBar,
  showSaveQuery,
  indexPatterns,
  timeRangeForSuggestionsOverride,
  filtersForSuggestions,
  buttonProps,
  isDisabled,
  onCloseFilterPopover,
  onLocalFilterCreate,
  onLocalFilterUpdate,
  suggestionsAbstraction
}) {
  const [renderedComponent, setRenderedComponent] = (0, _react.useState)('menu');
  const euiTheme = (0, _eui.useEuiTheme)();
  (0, _react.useEffect)(() => {
    if (openQueryBarMenu) {
      setRenderedComponent('menu');
    }
  }, [openQueryBarMenu]);
  const plainClosePopover = (0, _react.useCallback)(() => toggleFilterBarMenuPopover(false), [toggleFilterBarMenuPopover]);
  const closePopover = (0, _react.useCallback)(() => {
    onCloseFilterPopover([plainClosePopover]);
  }, [onCloseFilterPopover, plainClosePopover]);
  const normalContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'normalContextMenuPopover'
  });
  const onButtonClick = () => {
    toggleFilterBarMenuPopover(!openQueryBarMenu);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: strings.getFilterSetButtonLabel()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    size: "m",
    display: "empty",
    onClick: onButtonClick,
    isDisabled: isDisabled
  }, buttonProps, {
    style: {
      borderTopRightRadius: 0,
      borderBottomRightRadius: 0
    },
    iconType: "filter",
    "aria-label": strings.getFilterSetButtonLabel(),
    "data-test-subj": "showQueryBarMenu"
  })));
  const panels = (0, _query_bar_menu_panels.QueryBarMenuPanels)({
    filters,
    savedQuery,
    language,
    dateRangeFrom,
    dateRangeTo,
    query,
    showSaveQuery,
    showFilterBar,
    showQueryInput,
    savedQueryService,
    saveAsNewQueryFormComponent,
    manageFilterSetComponent,
    hiddenPanelOptions,
    nonKqlMode,
    disableQueryLanguageSwitcher,
    closePopover: plainClosePopover,
    onQueryBarSubmit,
    onFiltersUpdated,
    onClearSavedQuery,
    onQueryChange,
    setRenderedComponent
  });
  const renderComponent = () => {
    switch (renderedComponent) {
      case 'menu':
      default:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
          initialPanelId: 0,
          panels: panels,
          "data-test-subj": "queryBarMenuPanel"
        });
      case 'saveForm':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
          title: strings.getSavedQueryPopoverSaveChangesButtonText(),
          items: [/*#__PURE__*/_react.default.createElement("div", {
            style: {
              padding: 16
            }
          }, saveFormComponent)]
        });
      case 'saveAsNewForm':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
          items: [/*#__PURE__*/_react.default.createElement("div", {
            style: {
              padding: 16
            }
          }, saveAsNewQueryFormComponent)]
        });
      case 'addFilter':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
          items: [/*#__PURE__*/_react.default.createElement(_filter_editor_wrapper.FilterEditorWrapper, {
            key: "filter-editor-wrapper",
            indexPatterns: indexPatterns,
            filters: filters,
            timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
            filtersForSuggestions: filtersForSuggestions,
            onFiltersUpdated: onFiltersUpdated,
            onLocalFilterUpdate: onLocalFilterUpdate,
            onLocalFilterCreate: onLocalFilterCreate,
            closePopoverOnAdd: plainClosePopover,
            closePopoverOnCancel: plainClosePopover,
            suggestionsAbstraction: suggestionsAbstraction
          })]
        });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: normalContextMenuPopoverId,
    button: button,
    isOpen: openQueryBarMenu,
    closePopover: renderedComponent === 'addFilter' ? closePopover : plainClosePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    repositionOnScroll: true,
    "data-test-subj": "queryBarMenuPopover",
    panelProps: {
      css: (0, _add_filter_popover.popoverDragAndDropCss)(euiTheme)
    }
  }, renderComponent()));
}
const QueryBarMenu = (0, _filter_editor.withCloseFilterEditorConfirmModal)(QueryBarMenuComponent);
exports.QueryBarMenu = QueryBarMenu;