"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataPopover = NoDataPopover;
exports.strings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NO_DATA_POPOVER_STORAGE_KEY = 'data.noDataPopover';
const strings = {
  getNoDataPopoverContent: () => _i18n.i18n.translate('unifiedSearch.noDataPopover.content', {
    defaultMessage: "This time range doesn't contain any data. Increase or adjust the time range to see more fields and create charts."
  }),
  getNoDataPopoverSubtitle: () => _i18n.i18n.translate('unifiedSearch.noDataPopover.subtitle', {
    defaultMessage: 'Tip'
  }),
  getNoDataPopoverTitle: () => _i18n.i18n.translate('unifiedSearch.noDataPopover.title', {
    defaultMessage: 'Empty dataset'
  }),
  getNoDataPopoverDismissAction: () => _i18n.i18n.translate('unifiedSearch.noDataPopover.dismissAction', {
    defaultMessage: "Don't show again"
  })
};
exports.strings = strings;
function NoDataPopover({
  showNoDataPopover,
  storage,
  children
}) {
  const [noDataPopoverDismissed, setNoDataPopoverDismissed] = (0, _react.useState)(() => Boolean(storage.get(NO_DATA_POPOVER_STORAGE_KEY)));
  const [noDataPopoverVisible, setNoDataPopoverVisible] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (showNoDataPopover && !noDataPopoverDismissed) {
      setNoDataPopoverVisible(true);
    }
  }, [noDataPopoverDismissed, showNoDataPopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    onFinish: () => {},
    closePopover: () => {
      setNoDataPopoverVisible(false);
    },
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", {
      style: {
        maxWidth: 300
      }
    }, strings.getNoDataPopoverContent())),
    minWidth: 300,
    anchorPosition: "downCenter",
    anchorClassName: "eui-displayBlock",
    step: 1,
    stepsTotal: 1,
    isStepOpen: noDataPopoverVisible,
    subtitle: strings.getNoDataPopoverSubtitle(),
    title: strings.getNoDataPopoverTitle(),
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      flush: "right",
      color: "text",
      "data-test-subj": "noDataPopoverDismissButton",
      onClick: () => {
        storage.set(NO_DATA_POPOVER_STORAGE_KEY, true);
        setNoDataPopoverDismissed(true);
        setNoDataPopoverVisible(false);
      }
    }, strings.getNoDataPopoverDismissAction())
  }, /*#__PURE__*/_react.default.createElement("div", {
    onFocus: () => {
      setNoDataPopoverVisible(false);
    }
  }, children));
}