"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.FilterGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _css = require("@emotion/css");
var _utils = require("../utils");
var _filter_item = require("./filter_item");
var _context = require("./context");
var _utils2 = require("./utils");
var _filter_group = require("./filter_group.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getDelimiterLabel: booleanRelation => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.delimiterLabel', {
    defaultMessage: '{booleanRelation}',
    values: {
      booleanRelation
    }
  })
};
exports.strings = strings;
/** @internal **/
const Delimiter = ({
  color,
  booleanRelation
}) => {
  const xsPadding = (0, _eui.useEuiPaddingSize)('xs');
  const mPadding = (0, _eui.useEuiPaddingSize)('m');
  const backgroundColor = (0, _eui.useEuiBackgroundColor)(color);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _filter_group.delimiterCss)({
      padding: xsPadding,
      left: mPadding,
      background: backgroundColor
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "filter-builder__delimiter_text"
  }, strings.getDelimiterLabel(booleanRelation)));
};
const FilterGroup = ({
  filters,
  booleanRelation,
  path,
  reverseBackground = false,
  renderedLevel = 0,
  filtersCount
}) => {
  const {
    globalParams: {
      maxDepth,
      hideOr
    }
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const pathInArray = (0, _utils2.getPathInArray)(path);
  const isDepthReached = maxDepth <= pathInArray.length && renderedLevel > 0;
  const orDisabled = hideOr || isDepthReached && booleanRelation === _esQuery.BooleanRelation.AND;
  const andDisabled = isDepthReached && booleanRelation === _esQuery.BooleanRelation.OR;
  const removeDisabled = pathInArray.length <= 1 && filters !== undefined && Array.isArray(filters) && filters.length === 1;
  const shouldNormalizeFirstLevel = !path && filters && Array.isArray(filters) && filters.length === 1 && (0, _utils.getBooleanRelationType)(filters[0]);
  if (shouldNormalizeFirstLevel) {
    reverseBackground = true;
    renderedLevel -= 1;
  }
  const color = reverseBackground ? 'plain' : 'subdued';
  const renderedFilters = filters && Array.isArray(filters) && filters.map((filter, index, arrayRef) => {
    const showDelimiter = booleanRelation && index + 1 < arrayRef.length;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: index,
      direction: "column",
      gutterSize: shouldNormalizeFirstLevel ? 'none' : 'xs',
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_filter_item.FilterItem, {
      filter: filter,
      draggable: arrayRef.length !== 1,
      path: `${path}${path ? '.' : ''}${index}`,
      reverseBackground: reverseBackground,
      disableOr: orDisabled,
      disableAnd: andDisabled,
      disableRemove: removeDisabled,
      color: color,
      index: index,
      renderedLevel: renderedLevel,
      filtersCount: filtersCount
    })), showDelimiter && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(Delimiter, {
      color: color,
      booleanRelation: booleanRelation
    })));
  });
  return shouldNormalizeFirstLevel ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderedFilters) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: color,
    hasShadow: false,
    paddingSize: renderedLevel > 0 ? 'none' : 'xs',
    hasBorder: true,
    className: (0, _css.cx)({
      'filter-builder__panel': true,
      'filter-builder__panel-nested': renderedLevel > 0
    })
  }, renderedFilters);
};
exports.FilterGroup = FilterGroup;