"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloseFilterEditorConfirmModal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getTitle: () => _i18n.i18n.translate('unifiedSearch.filter.closeEditorConfirmModal.title', {
    defaultMessage: 'Unsaved changes'
  }),
  getCancelButton: () => _i18n.i18n.translate('unifiedSearch.filter.closeEditorConfirmModal.cancelButton', {
    defaultMessage: 'Cancel'
  }),
  getConfirmButton: () => _i18n.i18n.translate('unifiedSearch.filter.closeEditorConfirmModal.confirmButton', {
    defaultMessage: 'Discard changes'
  }),
  getWarningLabel: () => _i18n.i18n.translate('unifiedSearch.filter.closeEditorConfirmModal.warningLabel', {
    defaultMessage: 'If you leave now, your unsaved filters will be lost.'
  })
};
const CloseFilterEditorConfirmModal = /*#__PURE__*/(0, _react.memo)(function CloseFilterEditorConfirmModal(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, (0, _extends2.default)({
    "data-test-subj": "close-filter-editor-confirm-modal",
    title: strings.getTitle(),
    cancelButtonText: strings.getCancelButton(),
    confirmButtonText: strings.getConfirmButton(),
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, props), /*#__PURE__*/_react.default.createElement("p", null, strings.getWarningLabel()));
});
exports.CloseFilterEditorConfirmModal = CloseFilterEditorConfirmModal;