"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterBadgeLazy = exports.FilterBadgeGroupLazy = exports.FilterBadgeGroup = exports.FilterBadge = void 0;
Object.defineProperty(exports, "FilterContent", {
  enumerable: true,
  get: function () {
    return _filter_content.FilterContent;
  }
});
Object.defineProperty(exports, "FilterContentLazy", {
  enumerable: true,
  get: function () {
    return _filter_content.FilterContentLazy;
  }
});
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _filter_content = require("./filter_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
/**
 * The Lazily-loaded `FilterBadge` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const FilterBadgeLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./filter_badge'))));

/**
 * A `FilterBadge` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `FilterBadgeLazy` component lazily with
 * a predefined fallback and error boundary.
 */
exports.FilterBadgeLazy = FilterBadgeLazy;
const FilterBadge = (0, _sharedUxUtility.withSuspense)(FilterBadgeLazy);

/**
 * The Lazily-loaded `FilterBadgeGroup` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
exports.FilterBadge = FilterBadge;
const FilterBadgeGroupLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./filter_badge_group'))));

/**
 * A `FilterBadgeGroup` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `FilterBadgeGroupLazy` component lazily with
 * a predefined fallback and error boundary.
 */
exports.FilterBadgeGroupLazy = FilterBadgeGroupLazy;
const FilterBadgeGroup = (0, _sharedUxUtility.withSuspense)(FilterBadgeGroupLazy);
exports.FilterBadgeGroup = FilterBadgeGroup;