"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortingService = exports.ALPHABETICALLY = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const storageKey = 'unified_search_sorting';
const ALPHABETICALLY = 'alphabetically';
exports.ALPHABETICALLY = ALPHABETICALLY;
class SortingService {
  constructor(sortingStrategies, storage = new _public.Storage(window.localStorage)) {
    (0, _defineProperty2.default)(this, "sortingStrategyType", void 0);
    (0, _defineProperty2.default)(this, "direction", void 0);
    this.sortingStrategies = sortingStrategies;
    this.storage = storage;
    const {
      sortingStrategyType,
      direction
    } = this.getSorting();
    this.sortingStrategyType = sortingStrategyType;
    this.direction = direction;
  }
  getSorting() {
    var _parsedSorting, _parsedSorting2;
    let parsedSorting;
    try {
      parsedSorting = this.storage.get(storageKey);
    } catch (e) {
      parsedSorting = undefined;
    }
    return {
      sortingStrategyType: ((_parsedSorting = parsedSorting) === null || _parsedSorting === void 0 ? void 0 : _parsedSorting.sortingStrategyType) || ALPHABETICALLY,
      direction: ((_parsedSorting2 = parsedSorting) === null || _parsedSorting2 === void 0 ? void 0 : _parsedSorting2.direction) || _eui.SortDirection.ASC
    };
  }
  setDirection(direction) {
    this.direction = direction;
    this.storage.set(storageKey, {
      direction,
      sortingStrategyType: this.sortingStrategyType
    });
  }
  setSortingStrategyType(sortingStrategyType) {
    this.sortingStrategyType = sortingStrategyType;
    this.storage.set(storageKey, {
      sortingStrategyType,
      direction: this.direction
    });
  }
  getOrderDirections() {
    return [_eui.SortDirection.ASC, _eui.SortDirection.DESC];
  }
  getSortingStrategyTypes() {
    return [ALPHABETICALLY];
  }
  sortData(data) {
    return [...data].sort((a, b) => {
      const fn = this.sortingStrategies[this.sortingStrategyType];
      const firstComparableField = fn(a);
      const secondComparableField = fn(b);
      return this.compare(firstComparableField, secondComparableField);
    });
  }
  compare(a, b) {
    if (this.direction === _eui.SortDirection.ASC) {
      return a.localeCompare(b);
    }
    return b.localeCompare(a);
  }
}
exports.SortingService = SortingService;