"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionSelector = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SuggestionSelector = ({
  suggestions,
  activeSuggestion,
  onSuggestionChange
}) => {
  var _activeSuggestion$pre;
  const suggestionOptions = suggestions.map(sug => {
    return {
      label: sug.title,
      value: sug.title
    };
  });
  const selectedSuggestion = activeSuggestion ? [{
    label: activeSuggestion.title,
    value: activeSuggestion.title
  }] : [];
  const onSelectionChange = (0, _react2.useCallback)(newOptions => {
    const suggestion = newOptions.length ? suggestions.find(current => current.title === newOptions[0].value) : activeSuggestion;
    onSuggestionChange === null || onSuggestionChange === void 0 ? void 0 : onSuggestionChange(suggestion);
  }, [activeSuggestion, onSuggestionChange, suggestions]);
  const [suggestionsPopoverDisabled, setSuggestionaPopoverDisabled] = (0, _react2.useState)(false);
  const disableFieldPopover = (0, _react2.useCallback)(() => setSuggestionaPopoverDisabled(true), []);
  const enableFieldPopover = (0, _react2.useCallback)(() => setTimeout(() => setSuggestionaPopoverDisabled(false)), []);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const suggestionComboCss = (0, _react.css)`
    width: 100%;
    max-width: ${euiTheme.base * 15}px;
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: suggestionsPopoverDisabled ? undefined : activeSuggestion === null || activeSuggestion === void 0 ? void 0 : activeSuggestion.title,
    anchorProps: {
      css: suggestionComboCss
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "unifiedHistogramSuggestionSelector",
    prepend: /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: (_activeSuggestion$pre = activeSuggestion === null || activeSuggestion === void 0 ? void 0 : activeSuggestion.previewIcon) !== null && _activeSuggestion$pre !== void 0 ? _activeSuggestion$pre : 'empty'
    }),
    placeholder: _i18n.i18n.translate('unifiedHistogram.suggestionSelectorPlaceholder', {
      defaultMessage: 'Select visualization'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: suggestionOptions,
    selectedOptions: selectedSuggestion,
    onChange: onSelectionChange,
    fullWidth: true,
    isClearable: false,
    compressed: true,
    onFocus: disableFieldPopover,
    onBlur: enableFieldPopover,
    renderOption: option => {
      var _suggestion$previewIc;
      const suggestion = suggestions.find(s => {
        return s.title === option.label;
      });
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        responsive: false
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: null
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: (_suggestion$previewIc = suggestion === null || suggestion === void 0 ? void 0 : suggestion.previewIcon) !== null && _suggestion$previewIc !== void 0 ? _suggestion$previewIc : 'empty'
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, option.label));
    }
  }));
};
exports.SuggestionSelector = SuggestionSelector;