"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartConfigPanel = ChartConfigPanel;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ChartConfigPanel({
  services,
  lensAttributesContext,
  lensAdapters,
  lensEmbeddableOutput$,
  currentSuggestion,
  isFlyoutVisible,
  setIsFlyoutVisible,
  isPlainRecord,
  query,
  onSuggestionChange
}) {
  const [editLensConfigPanel, setEditLensConfigPanel] = (0, _react.useState)(null);
  const previousSuggestion = (0, _react.useRef)(undefined);
  const previousAdapters = (0, _react.useRef)(undefined);
  const previousQuery = (0, _react.useRef)(undefined);
  const updateSuggestion = (0, _react.useCallback)((datasourceState, visualizationState) => {
    const updatedSuggestion = {
      ...currentSuggestion,
      ...(datasourceState && {
        datasourceState
      }),
      ...(visualizationState && {
        visualizationState
      })
    };
    onSuggestionChange === null || onSuggestionChange === void 0 ? void 0 : onSuggestionChange(updatedSuggestion);
  }, [currentSuggestion, onSuggestionChange]);
  (0, _react.useEffect)(() => {
    var _lensAdapters$tables, _previousSuggestion$c;
    const tablesAdapters = lensAdapters === null || lensAdapters === void 0 ? void 0 : (_lensAdapters$tables = lensAdapters.tables) === null || _lensAdapters$tables === void 0 ? void 0 : _lensAdapters$tables.tables;
    const dataHasChanged = Boolean(tablesAdapters) && !(0, _lodash.isEqual)(previousAdapters.current, tablesAdapters) && query !== (previousQuery === null || previousQuery === void 0 ? void 0 : previousQuery.current);
    async function fetchLensConfigComponent() {
      const Component = await services.lens.EditLensConfigPanelApi();
      const panel = /*#__PURE__*/_react.default.createElement(Component, {
        attributes: lensAttributesContext.attributes,
        updatePanelState: updateSuggestion,
        lensAdapters: lensAdapters,
        output$: lensEmbeddableOutput$,
        displayFlyoutHeader: true,
        closeFlyout: () => {
          setIsFlyoutVisible(false);
        },
        wrapInFlyout: true,
        datasourceId: "textBased"
      });
      setEditLensConfigPanel(panel);
      previousSuggestion.current = currentSuggestion;
      previousAdapters.current = tablesAdapters;
      if (dataHasChanged) {
        previousQuery.current = query;
      }
    }
    const suggestionHasChanged = (currentSuggestion === null || currentSuggestion === void 0 ? void 0 : currentSuggestion.title) !== (previousSuggestion === null || previousSuggestion === void 0 ? void 0 : (_previousSuggestion$c = previousSuggestion.current) === null || _previousSuggestion$c === void 0 ? void 0 : _previousSuggestion$c.title);
    // rerender the component if the data has changed or the suggestion
    // as I can have different suggestions for the same data
    if (isPlainRecord && (dataHasChanged || suggestionHasChanged || !isFlyoutVisible)) {
      fetchLensConfigComponent();
    }
  }, [lensAttributesContext.attributes, services.lens, updateSuggestion, isPlainRecord, currentSuggestion, query, isFlyoutVisible, setIsFlyoutVisible, lensAdapters, lensEmbeddableOutput$]);
  return isPlainRecord ? editLensConfigPanel : null;
}