"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_HEIGHT = exports.MAX_LINES_CLASSIC_TABLE = exports.MARGIN_BOTTOM = exports.DocViewerSource = void 0;
require("./source.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _discoverUtils = require("@kbn/discover-utils");
var _plugin = require("../../plugin");
var _hooks = require("../../hooks");
var _get_height = require("./get_height");
var _json_code_editor = require("../json_code_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Ihe number of lines displayed without scrolling used for classic table, which renders the component
// inline limitation was necessary to enable virtualized scrolling, which improves performance
const MAX_LINES_CLASSIC_TABLE = 500;
// Displayed margin of the code editor to the window bottom when rendered in the document explorer flyout
exports.MAX_LINES_CLASSIC_TABLE = MAX_LINES_CLASSIC_TABLE;
const MARGIN_BOTTOM = 25;
// Minimum height for the source content to guarantee minimum space when the flyout is scrollable.
exports.MARGIN_BOTTOM = MARGIN_BOTTOM;
const MIN_HEIGHT = 400;
exports.MIN_HEIGHT = MIN_HEIGHT;
const DocViewerSource = ({
  id,
  index,
  dataView,
  width,
  hasLineNumbers,
  textBasedHits,
  onRefresh
}) => {
  const [editor, setEditor] = (0, _react.useState)();
  const [editorHeight, setEditorHeight] = (0, _react.useState)();
  const [jsonValue, setJsonValue] = (0, _react.useState)('');
  const {
    uiSettings
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const useNewFieldsApi = !uiSettings.get(_discoverUtils.SEARCH_FIELDS_FROM_SOURCE);
  const useDocExplorer = !uiSettings.get(_discoverUtils.DOC_TABLE_LEGACY);
  const [requestState, hit] = (0, _hooks.useEsDocSearch)({
    id,
    index,
    dataView,
    requestSource: useNewFieldsApi,
    textBasedHits
  });
  (0, _react.useEffect)(() => {
    if (requestState === _unifiedDocViewer.ElasticRequestState.Found && hit) {
      setJsonValue(JSON.stringify(hit.raw, undefined, 2));
    }
  }, [requestState, hit]);

  // setting editor height
  // - classic view: based on lines height and count to stretch and fit its content
  // - explorer: to fill the available space of the document flyout
  (0, _react.useEffect)(() => {
    if (!editor) {
      return;
    }
    const editorElement = editor.getDomNode();
    if (!editorElement) {
      return;
    }
    const height = (0, _get_height.getHeight)(editor, useDocExplorer);
    if (height === 0) {
      return;
    }
    if (!jsonValue || jsonValue === '') {
      setEditorHeight(0);
    } else {
      setEditorHeight(height);
    }
  }, [editor, jsonValue, useDocExplorer, setEditorHeight]);
  const loadingState = /*#__PURE__*/_react.default.createElement("div", {
    className: "sourceViewer__loading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    className: "sourceViewer__loadingSpinner"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.loadingJSON",
    defaultMessage: "Loading JSON"
  })));
  const errorMessageTitle = /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('unifiedDocViewer.sourceViewer.errorMessageTitle', {
    defaultMessage: 'An Error Occurred'
  }));
  const errorMessage = /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('unifiedDocViewer.sourceViewer.errorMessage', {
    defaultMessage: 'Could not fetch data at this time. Refresh the tab to try again.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    onClick: onRefresh
  }, _i18n.i18n.translate('unifiedDocViewer.sourceViewer.refresh', {
    defaultMessage: 'Refresh'
  })));
  const errorState = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: errorMessageTitle,
    body: errorMessage
  });
  if (requestState === _unifiedDocViewer.ElasticRequestState.Error || requestState === _unifiedDocViewer.ElasticRequestState.NotFound) {
    return errorState;
  }
  if (requestState === _unifiedDocViewer.ElasticRequestState.Loading || jsonValue === '') {
    return loadingState;
  }
  return /*#__PURE__*/_react.default.createElement(_json_code_editor.JSONCodeEditorCommonMemoized, {
    jsonValue: jsonValue,
    width: width,
    height: editorHeight,
    hasLineNumbers: hasLineNumbers,
    onEditorDidMount: editorNode => setEditor(editorNode)
  });
};
exports.DocViewerSource = DocViewerSource;