"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryActionStorage = exports.AbstractActionStorage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable max-classes-per-file */

/**
 * This CRUD interface needs to be implemented by dynamic action users if they
 * want to persist the dynamic actions. It has a default implementation in
 * Embeddables, however one can use the dynamic actions without Embeddables,
 * in that case they have to implement this interface.
 */

class AbstractActionStorage {
  constructor() {
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
  }
  async count() {
    return (await this.list()).length;
  }
  async read(eventId) {
    const events = await this.list();
    const event = events.find(ev => ev.eventId === eventId);
    if (!event) throw new Error(`Event [eventId = ${eventId}] not found.`);
    return event;
  }
}

/**
 * This is an in-memory implementation of ActionStorage. It is used in testing,
 * but can also be used production code to store events in memory.
 */
exports.AbstractActionStorage = AbstractActionStorage;
class MemoryActionStorage extends AbstractActionStorage {
  constructor(events = []) {
    super();
    this.events = events;
  }
  async list() {
    return this.events.map(event => ({
      ...event
    }));
  }
  async create(event) {
    this.events = [...this.events, {
      ...event
    }];
  }
  async update(event) {
    const index = this.events.findIndex(({
      eventId
    }) => eventId === event.eventId);
    if (index < 0) throw new Error(`Event [eventId = ${event.eventId}] not found`);
    this.events = [...this.events.slice(0, index), {
      ...event
    }, ...this.events.slice(index + 1)];
  }
  async remove(eventId) {
    const index = this.events.findIndex(ev => eventId === ev.eventId);
    if (index < 0) throw new Error(`Event [eventId = ${eventId}] not found`);
    this.events = [...this.events.slice(0, index), ...this.events.slice(index + 1)];
  }
}
exports.MemoryActionStorage = MemoryActionStorage;