"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WELCOME_MESSAGE_TEST_SUBJ = exports.DrilldownHelloBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const WELCOME_MESSAGE_TEST_SUBJ = 'drilldownsWelcomeMessage';
exports.WELCOME_MESSAGE_TEST_SUBJ = WELCOME_MESSAGE_TEST_SUBJ;
const DrilldownHelloBar = ({
  docsLink,
  onHideClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": WELCOME_MESSAGE_TEST_SUBJ
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "help"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, _i18n.txtHelpText)), docsLink && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docsLink,
    target: "_blank",
    external: true
  }, _i18n.txtViewDocsLinkLabel))), !!onHideClick && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: onHideClick
  }, _i18n.txtHideHelpButtonLabel))));
};
exports.DrilldownHelloBar = DrilldownHelloBar;